package com.instabug.library.networkv2.request;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

import static com.instabug.library.networkv2.request.RequestType.FILE_DOWNLOAD;
import static com.instabug.library.networkv2.request.RequestType.MULTI_PART;
import static com.instabug.library.networkv2.request.RequestType.NORMAL;
import static com.instabug.library.networkv2.request.RequestType.UNDEFINED;

@IntDef({NORMAL, MULTI_PART, FILE_DOWNLOAD, UNDEFINED})
@Retention(RetentionPolicy.SOURCE)
public @interface RequestType {
    /**
     Normal http request with application/json body
     */
    int NORMAL = 1;

    /**
     Normal http request with multipart body
     */
    int MULTI_PART = 2;

    /**
     Download a file/assets
     */
    int FILE_DOWNLOAD = 3;

    /**
     Undefined state of the request type
     */
    int UNDEFINED = -1;
}
