package com.instabug.library.networkv2.request;

import static com.instabug.library.networkv2.request.Constants.APM_BASE_URL;

import com.instabug.library.BuildConfig;

public final class Endpoints {
    // V3 Sessions
    private static final String SESSION_PATH = "/sessions/v3";
    public static final String V3_SESSION = APM_BASE_URL + SESSION_PATH;

    //Chats module endpoints
    public static final String TRIGGER_CHAT = "/chats";
    public static final String SEND_MESSAGE = "/chats/:chat_number/messages";
    public static final String ADD_MESSAGE_ATTACHMENT = "/chats/:chat_number/messages/:message_id/attachments";
    public static final String SYNC_CHATS = "/chats/sync";
    public static final String PUSH_TOKEN = "/push_token";
    public static final String CHAT_LOGS = "/chats/:chat_token/state_logs";


    //Surveys module endpoints
    private static final String announcementVersion = "v2";
    private final static String surveysVersion = "v8";

    public static final String GET_ANNOUNCEMENTS = "/announcements/" + announcementVersion;
    public static final String SUBMIT_ANNOUNCEMENT = "/announcements/:announcement_id/" + announcementVersion + "/responses";
    public static final String GET_SURVEYS = "/surveys/" + surveysVersion;
    public static final String RESOLVE_IP = "/resolve_ip";
    public static final String SUBMIT_SURVEY = "/surveys/:survey_id/" + surveysVersion + "/responses";

    //Crash module endpoints
    public static final String REPORT_ANR = "/crashes/anr";
    public static final String CRASH_LOGS = "/crashes/:crash_token/state_logs";
    public static final String ADD_CRASH_ATTACHMENT = "/crashes/:crash_token/attachments";
    public static final String REPORT_CRASH = "/crashes";
    public static final String REPORT_FATAL_HANG = "/crashes/android_fatal_hangs";
    public static final String REPORT_USER_TERMINATION = "/crashes/android_user_termination";
    public static final String REPORT_NON_FATAL = "/crashes/non_fatal";

    //Core module endpoints
    public static final String FIRST_SEEN = "/first_seen";
    public static final String APP_SETTINGS = "/features";
    public static final String MIGRATE_UUID = "/migrate_uuid";
    public final static String PRODUCTION_LOGS_URL = "https://" + BuildConfig.DOMAIN + "/sdklogs/upload";
    public final static String SEND_SESSION = "/sessions/v2";
    public final static String USER_ATTRIBUTES = "/users/attributes";
    public final static String MAPPED_TOKEN = "/mapped_token";

    // Bug module endpoints
    public static final String REPORT_BUG = "/bugs";
    public static final String ADD_BUG_ATTACHMENT = "/bugs/:bug_token/attachments";
    public static final String BUG_LOGS = "/bugs/:bug_token/state_logs";
    public static final String REPORT_CATEGORIES = "/application_categories";

    // Feature Request module endpoints
    public static final String GET_FEATURES_REQUEST = "/feature_reqs";
    public static final String VOTE_FEATURE = "/feature_reqs/:feature_req_id/like";
    public static final String SEARCH = "/search";
    public static final String GET_FEATURE_TIMELINE = "/feature_reqs/:feature_req_id/timeline";
    public static final String ADD_COMMENT = "/feature_reqs/:feature_req_id/comment";
    public static final String ADD_NEW_FEATURE = "/feature_reqs";

    // Session-Replay
    public static final String SESSION_LOGS = APM_BASE_URL + "/sessions/:session_id/logs";
    public static final String SESSION_SCREENSHOTS = APM_BASE_URL + "/sessions/:session_id/attachments";


}
