package com.instabug.library.networkv2.authorization.ispx

import com.instabug.library.networkv2.request.Constants
import com.instabug.library.networkv2.request.Header

/**
 * A class for providing sensitive attributes for SDK requests authorization.
 * The general anatomy of this variant is receiving a random number with a specific criteria, combine
 * it on bits level with a stateful value to compose a start and end indices for a specific value.
 * The exception to that anatomy is app secret and client ID. For those, a native library is loaded
 * for obtaining these attributes from the native layer.
 */
@Suppress("MagicNumber", "FunctionName", "TooManyFunctions")
class LSP : ISP {

    init {
        runCatching { System.loadLibrary("ibg-native") }
    }

    override fun Vx8Q(random: Int): String = Csqp()

    override fun Bp1C(random: Int): String = Constants.SEPARATOR

    override fun Ulvs(random: Int): String = gQlh()

    override fun UMUr(random: Int): String = Header.AUTHORIZATION

    override fun BQfA(random: Int): String = Constants.AMX

    override fun fPm2(): String = Header.CONTENT_TYPE

    override fun imxU(random: Int): String = Header.ACCEPT_CHARSET

    override fun E5QP(): String = Constants.UTF_8

    // Secret
    external fun Csqp(): String

    // Client
    external fun gQlh(): String
}
