package com.instabug.library.internal.utils.stability.handler.penalty;

import androidx.annotation.NonNull;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

public class LogPenaltyHandler implements PenaltyHandler {

    @NonNull
    private final String tag;

    public LogPenaltyHandler(@NonNull String tag) {
        this.tag = tag;
    }

    @PenaltyType
    @Override
    public int getPenaltyType() {
        return PenaltyType.LOG;
    }

    @Override
    public void handle(@NonNull Exception e) {
        InstabugSDKLogger.e(Constants.LOG_TAG, e.getClass().getSimpleName(), e);
    }
}
