package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions.DB_V3

class DBMigrationV3(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration? by lazy { DBMigrationV2(db) }
    override val version: Int
        get() = DB_V3

    override fun execute() = runLogic { db.execSQL(IBGDbContract.BugEntry.CREATE_TABLE) }
}