package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMComposeSpansEntry
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMSessionMetaDataEntry
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMSessionMetaDataEntry.COUNT_DEFAULT_VALUE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DEFAULT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.INTEGER_TYPE

class Migration_42_43 : Migration {

    override fun migrate(db: SQLiteDatabase?) {
        db?.apply {
            createApmComposeSpansTable()
            addComposeSpansFieldsToApmSessionMetadata()
        }
    }

    private fun SQLiteDatabase.createApmComposeSpansTable() {
        execSQL(APMComposeSpansEntry.CREATE_TABLE_QUERY)
    }

    private fun SQLiteDatabase.addComposeSpansFieldsToApmSessionMetadata() {
        execSQL(
            "ALTER TABLE ${APMSessionMetaDataEntry.TABLE_NAME} " +
                    "ADD COLUMN ${APMSessionMetaDataEntry.COLUMN_COMPOSE_SPANS_COUNT} " +
                    "$INTEGER_TYPE $DEFAULT $COUNT_DEFAULT_VALUE"
        )
        execSQL(
            "ALTER TABLE ${APMSessionMetaDataEntry.TABLE_NAME} " +
                    "ADD COLUMN ${APMSessionMetaDataEntry.COLUMN_COMPOSE_SPANS_DROPPED_COUNT} " +
                    "$INTEGER_TYPE $DEFAULT $COUNT_DEFAULT_VALUE"
        )
    }
}