package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.diagnostics.diagnostics_db.INTEGER_TYPE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract

private const val ALTER_TABLE_QUERY = "ALTER TABLE %s ADD COLUMN %s%s DEFAULT 0"

class Migration_39_40 : Migration {

    override fun migrate(db: SQLiteDatabase?) {
        db?.apply {
            addFragmentsTables()
            addFragmentsColumnsToSessionMetadata()
        }
    }

    private fun SQLiteDatabase.addFragmentsTables() {
        execSQL(InstabugDbContract.APMFragmentEntry.CREATE_TABLE_QUERY)
        execSQL(InstabugDbContract.APMFragmentEventsEntry.CREATE_TABLE_QUERY)
    }

    private fun SQLiteDatabase.addFragmentsColumnsToSessionMetadata() {
        ALTER_TABLE_QUERY.format(
            InstabugDbContract.APMSessionMetaDataEntry.TABLE_NAME,
            InstabugDbContract.APMSessionMetaDataEntry.COLUMN_FRAGMENT_SPANS_COUNT,
            INTEGER_TYPE
        ).let { query -> execSQL(query) }

        ALTER_TABLE_QUERY.format(
            InstabugDbContract.APMSessionMetaDataEntry.TABLE_NAME,
            InstabugDbContract.APMSessionMetaDataEntry.COLUMN_FRAGMENT_SPANS_DROPPED_COUNT,
            INTEGER_TYPE
        ).let { query -> execSQL(query) }
    }

}