package com.instabug.library.internal.storage.cache.db.migrations;

import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.TEXT_TYPE;

import android.database.sqlite.SQLiteDatabase;

import com.instabug.library.internal.storage.cache.db.InstabugDBVersions;
import com.instabug.library.internal.storage.cache.db.InstabugDbContract;

/**
 * Allows the database to migrate from version 30 to version 31
 * <p>
 * Schemas are defined in {@link InstabugDbContract}. Any changes to these schemas will require
 * a migration.
 *
 * @see InstabugDBVersions
 */
public class Migration_30_31 implements Migration {

    @Override
    public void migrate(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE " + InstabugDbContract.SessionEntry.TABLE_NAME
                + " ADD COLUMN " + InstabugDbContract.SessionEntry.COLUMN_STITCHED_SESSION_LEAD + " BOOLEAN"
                + " DEFAULT 0");
        db.execSQL(InstabugDbContract.APMUiLoadingMetricEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMUiLoadingStageEntry.CREATE_TABLE_QUERY);
        db.execSQL("ALTER TABLE " + InstabugDbContract.APMNetworkLogEntry.TABLE_NAME + " ADD COLUMN " + InstabugDbContract.APMNetworkLogEntry.COLUMN_GRAPH_QL_QUERY_NAME + TEXT_TYPE);
        db.execSQL("ALTER TABLE " + InstabugDbContract.APMNetworkLogEntry.TABLE_NAME + " ADD COLUMN " + InstabugDbContract.APMNetworkLogEntry.COLUMN_SERVER_ERROR_MESSAGE + TEXT_TYPE);
        db.execSQL("ALTER TABLE " + InstabugDbContract.DanglingAPMNetworkLogEntry.TABLE_NAME + " ADD COLUMN " + InstabugDbContract.DanglingAPMNetworkLogEntry.COLUMN_GRAPH_QL_QUERY_NAME + TEXT_TYPE);
        db.execSQL("ALTER TABLE " + InstabugDbContract.DanglingAPMNetworkLogEntry.TABLE_NAME + " ADD COLUMN " + InstabugDbContract.DanglingAPMNetworkLogEntry.COLUMN_SERVER_ERROR_MESSAGE + TEXT_TYPE);

    }
}
