package com.instabug.library.internal.orchestrator;

import com.instabug.library.internal.storage.cache.user.UserCacheManager;

public class UpdateLastSeenAction implements Action {

    private final String uuid;
    private final long timeStamp;

    public UpdateLastSeenAction(String uuid, long timeStamp) {
        this.uuid = uuid;
        this.timeStamp = timeStamp;
    }

    @Override
    public void run() throws Exception {
        UserCacheManager.updateLastSeen(uuid, timeStamp);
    }
}
