package com.instabug.library.internal.orchestrator;

import com.instabug.library.internal.storage.cache.user.UserCacheManager;

public class ArchiveSessionCountAction implements Action {

    private final String uuid;
    private final int sessionsCount;

    public ArchiveSessionCountAction(String uuid, int sessionsCount) {
        this.uuid = uuid;
        this.sessionsCount = sessionsCount;
    }

    @Override
    public void run() throws Exception {
        UserCacheManager.updateSessionCount(uuid, sessionsCount);
    }
}
