package com.instabug.library.internal.dataretention.core;

import java.util.Collection;

import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;

/**
 * A representation of the data scope hat holds the bare minimum info needed to access the
 * actual data
 */
public interface Scope<T extends Record<?>> {

    /**
     * @return all data records
     */
    @NonNull
    @WorkerThread
    Collection<T> records();

    /**
     * @return data size (i.e. number of database records, disk size, etc...)
     * @see Contract#maxRetentionSize()
     */
    long size();
}
