package com.instabug.library.internal.crossplatform

fun interface OnFeaturesUpdatedListener {
    operator fun invoke()
}

interface OnFeaturesUpdatedHandler {
    var onFeatureUpdatedListener: OnFeaturesUpdatedListener?
}

class OnFeaturesUpdatedHandlerImpl : OnFeaturesUpdatedHandler {

    private val onFeaturesUpdatedListenerLock = Any()

    override var onFeatureUpdatedListener: OnFeaturesUpdatedListener? = null
        get() = synchronized(onFeaturesUpdatedListenerLock) {
            field
        }
        set(value) {
            synchronized(onFeaturesUpdatedListenerLock) {
                field = value
            }
        }
}
