package com.instabug.library.instacapture.screenshot;

import android.graphics.Rect;
import android.view.View;
import android.view.WindowManager;

/**
 * Created by tarek on 5/18/16.
 */
public class RootViewInfo {

    private final View view;
    private final WindowManager.LayoutParams layoutParams;
    private final int top;
    private final int left;
    private final Rect rect;

    public RootViewInfo(View view, Rect rect, WindowManager.LayoutParams layoutParams) {
        this.view = view;
        int[] onScreenPosition = new int[2];
        view.getLocationOnScreen(onScreenPosition);
        left = onScreenPosition[0];
        top = onScreenPosition[1];
        this.rect = rect;
        this.layoutParams = layoutParams;
    }

    public Rect getRect() {
        return rect;
    }

    public View getView() {
        return view;
    }

    public int getTop() {
        return top;
    }

    public int getLeft() {
        return left;
    }

    public WindowManager.LayoutParams getLayoutParams() {
        return layoutParams;
    }

    public boolean isDialog() {
        return layoutParams.type == WindowManager.LayoutParams.TYPE_APPLICATION;
    }

    public boolean isComposeBottomSheet() {
        return view.getClass().getName().equals("androidx.compose.material3.ModalBottomSheetWindow");
    }
    public boolean isOverlayViews(){
        return isDialog() || isComposeBottomSheet();
    }
}
