package com.instabug.library.encryption

import android.os.Build
import android.security.keystore.KeyGenParameterSpec
import android.security.keystore.KeyProperties
import androidx.annotation.RequiresApi
import com.instabug.library.Constants
import com.instabug.library.diagnostics.IBGDiagnostics
import com.instabug.library.util.InstabugSDKLogger
import java.security.Key
import java.security.KeyStore
import javax.crypto.KeyGenerator

object Post22KeyGenerator {

    private const val androidKeyStore = "AndroidKeyStore"
    private const val AES_KEY_ALIAS = "aes_key"
    private val KEY_PASSWORD = "aes_key_password".toCharArray()

    private var keystore: KeyStore? = null


    init {
        if (keystore == null) {
            try {
                keystore = KeyStore.getInstance(androidKeyStore)
                keystore?.load(null)
            } catch (e: Exception) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Error while instantiating keystore")
                IBGDiagnostics.reportNonFatal(e, "Error while instantiating keystore")
                keystore = null
            }
        }
    }

    @RequiresApi(Build.VERSION_CODES.M)
    private fun generateKeyApi23() {
        try {
            val keyGenerator: KeyGenerator = KeyGenerator.getInstance(KeyProperties.KEY_ALGORITHM_AES, androidKeyStore)
            keyGenerator.init(KeyGenParameterSpec.Builder(AES_KEY_ALIAS, KeyProperties.PURPOSE_ENCRYPT or KeyProperties.PURPOSE_DECRYPT)
                    .setBlockModes(KeyProperties.BLOCK_MODE_GCM)
                    .setEncryptionPaddings(KeyProperties.ENCRYPTION_PADDING_NONE)
                    .setKeySize(256)
                    .setRandomizedEncryptionRequired(false)
                    .build()
            )
            keyGenerator.generateKey()
        } catch (e: java.lang.Exception) {
            InstabugSDKLogger.e(
                Constants.LOG_TAG,
                "Failed to generate encryption key using keystore"
            )
            IBGDiagnostics.reportNonFatal(e, "Failed to generate encryption key using keystore")
        }
    }

    @JvmStatic
    @RequiresApi(Build.VERSION_CODES.M)
    fun getKeyPostApi22(): Key? {
        if (keystore?.containsAlias(AES_KEY_ALIAS) != true) {
            generateKeyApi23()
        }

        return keystore?.getKey(AES_KEY_ALIAS, KEY_PASSWORD)
    }
}