package com.instabug.library.diagnostics.sdkEvents

import com.instabug.library.diagnostics.sdkEvents.cache.SDKEventsCachingManager
import com.instabug.library.diagnostics.sdkEvents.di.SDKEventsServiceLocator
import com.instabug.library.diagnostics.sdkEvents.di.SDKEventsServiceLocator.SDK_EVENTS_LOCK
import com.instabug.library.diagnostics.sdkEvents.models.SDKEvent
import java.util.concurrent.ThreadPoolExecutor

internal class SDKEventsManagerImpl : SDKEventsManager {

    private val executor: ThreadPoolExecutor
        get() = SDKEventsServiceLocator.sdkEventsExecutor
    private val cachingManager: SDKEventsCachingManager
        get() = SDKEventsServiceLocator.sdkEventsCachingManager

    override fun saveEvent(event: SDKEvent) = executor.execute {
        synchronized(SDK_EVENTS_LOCK) { cachingManager.saveEvent(event) }
    }

    override fun saveEventImmediately(event: SDKEvent) =
        synchronized(SDK_EVENTS_LOCK) { cachingManager.saveEvent(event) }

    override fun deleteManyEvents(keys: Collection<String>?) = executor.execute {
        synchronized(SDK_EVENTS_LOCK) { cachingManager.deleteManyEvents(keys) }
    }

    override fun clearCache() = executor.execute {
        synchronized(SDK_EVENTS_LOCK) { cachingManager.clearCache() }
    }

    override fun updateSyncedRecords(syncedRecords: List<SDKEvent>) = executor.execute {
        synchronized(SDK_EVENTS_LOCK) { cachingManager.updateSyncedRecords(syncedRecords) }
    }

    override fun deleteZeroCountedEvents() = executor.execute {
        synchronized(SDK_EVENTS_LOCK) { cachingManager.deleteZeroCountedEvents() }
    }
}