package com.instabug.library.diagnostics.nonfatals.networking.mapping;

import androidx.annotation.NonNull;

import com.instabug.library.diagnostics.nonfatals.model.NonFatal;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.List;

/**
 * Created by Shannan on 06/09/2021.
 */
public interface NonFatalMapper {
    /**
     * Serializes list of @{@link NonFatal} to @{@link JSONArray}
     *
     * @param nonFatals list of nonFatals to be serialized
     * @return Json array of serialized non-fatals
     * @throws JSONException when serialization fails
     */

    @NonNull
    JSONArray toJSONArray(@NonNull List<NonFatal> nonFatals) throws JSONException;
}
