package com.instabug.library.core.ui;

import androidx.annotation.Nullable;

import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;

import java.lang.ref.WeakReference;

/**
 * Created by tarek on 9/25/16.
 */
public abstract class BasePresenter<V extends BaseContract.View> implements BaseContract.Presenter {

    @Nullable
    protected WeakReference<V> view;

    @Nullable
    protected IBGTheme theme;

    public BasePresenter(V view) {

        this.view = new WeakReference<>(view);
        theme = SettingsManager.getInstance().getIBGTheme();
    }

    @Override
    @Nullable
    public IBGTheme getTheme() {
        return theme;
    }

    public void onDestroy() {
        view = null;
    }

}
