package com.instabug.library.core.ui;

import androidx.annotation.Nullable;

import com.instabug.library.model.IBGTheme;

/**
 * Created by tarek on 9/25/16.
 */
public interface BaseContract {

    interface View<C> {

        /**
         * @return Current view context
         */
        C getViewContext();

        /**
         * Finish current activity
         */
        void finishActivity();

    }

    interface Presenter {
        @Nullable
        IBGTheme getTheme();
    }

    interface Model {

        void onDestroy();
    }
}


