package com.instabug.library.core.eventbus;

import android.content.res.Configuration;

import androidx.annotation.Nullable;

public class CurrentActivityConfigurationChange extends EventBus<CurrentActivityConfigurationChange> {
    static private CurrentActivityConfigurationChange currentActivityConfigurationChange;
    @Nullable
    private Configuration newConfig;

    public static CurrentActivityConfigurationChange getInstance() {
        if (currentActivityConfigurationChange==null)
            currentActivityConfigurationChange = new CurrentActivityConfigurationChange();
        return currentActivityConfigurationChange;

    }

    public void setNewConfig(@Nullable Configuration newConfig) {
        this.newConfig = newConfig;
    }

    @Nullable
    public Configuration getNewConfig() {
        return newConfig;
    }
}
