package com.instabug.library;

import android.util.Log;

import com.instabug.library.internal.utils.PlaceHolderDeprecationLogger;
import com.instabug.library.util.StringUtility;

import java.util.HashMap;
import java.util.Map;

import androidx.annotation.Nullable;

import static com.instabug.library.InstabugCustomTextPlaceHolder.Key;
import static com.instabug.library.InstabugCustomTextPlaceHolder.TITLE_CHAR_LIMIT;

class InstabugCustomTextPlaceHolderDelegate {

    private final Map<Key, String> map;

    InstabugCustomTextPlaceHolderDelegate() {
        this.map = new HashMap<>();
    }

    void set(Key key, String value) {
        PlaceHolderDeprecationLogger.logWarningIfDeprecated(key);
        map.put(key, ellipsizeIfLimitExceeded(key, value));
    }

    @Nullable
    String get(Key key) {
        return map.get(key);
    }

    void setMap(Map<Key, String> map) {
        this.map.clear();
        this.map.putAll(map);
    }

    private String ellipsizeIfLimitExceeded(Key key, String value) {
        if (key.charLimit() > -1 && value.length() > key.charLimit()) {
            Log.w("INSTABUG", "The max "
                    + (key.charLimit() == TITLE_CHAR_LIMIT ? "title" : "description")
                    + " length is " + key.charLimit() + ". Any extra characters will be trimmed.");
            return StringUtility.ellipsize(value, key.charLimit());
        }
        return value;
    }
}
