package com.instabug.library.util.memory;

import android.app.ActivityManager;
import android.content.Context;
import android.util.Log;

import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.MathUtils;

public class MemoryUtils {


    public static long getFreeMemory(Context context) {
        ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        if (activityManager != null) {
            activityManager.getMemoryInfo(memoryInfo);
            return MathUtils.getPercentageOf(memoryInfo.availMem, 70);

        }
        return 0;
    }

    public static boolean isLowMemory(@Nullable Context context) {
        if (context == null) return true;
        try {
            ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            if (activityManager != null) {
                activityManager.getMemoryInfo(memoryInfo);
                return memoryInfo.lowMemory;
            }
        } catch (OutOfMemoryError | Exception exception) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error: " + exception.getMessage() + "while trying to evaluate isLowMemory");
        }
        return true;
    }
}
