package com.instabug.library.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.os.Build;

import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;

import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;


public class NotificationUtils {

    private static final String SCREEN_RECORDING_ID = "ibg-screen-recording";

    @RequiresApi(29)
    public static void createAndShowForegroundNotification(Service service,
                                                           @StringRes
                                                           int title,
                                                           int notificationId,
                                                           int foregroundServiceType) {

        final NotificationCompat.Builder builder = getNotificationBuilder(service,
                SCREEN_RECORDING_ID, // Channel id
                NotificationManagerCompat.IMPORTANCE_LOW);
        builder.setOngoing(false)
                .setAutoCancel(true)
                .setSmallIcon(R.drawable.ibg_core_ic_instabug_logo)
                .setContentText(LocaleUtils.getLocaleStringResource(
                        InstabugCore.getLocale(service.getApplicationContext()),
                        title,
                        service.getApplicationContext()));

        Notification notification = builder.build();

        service.startForeground(notificationId, notification, foregroundServiceType);

    }

    public static NotificationCompat.Builder getNotificationBuilder(Context context,
                                                                    String channelId,
                                                                    int importance) {
        NotificationCompat.Builder builder;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            prepareChannel(context, channelId, importance);
            builder = new NotificationCompat.Builder(context, channelId);
        } else {
            builder = new NotificationCompat.Builder(context);
        }
        return builder;
    }

    @TargetApi(26)
    private static void prepareChannel(Context context, String id, int importance) {
        final String appName = "Screen Recording Service";
        final NotificationManager nm = (NotificationManager) context.getSystemService(Activity.NOTIFICATION_SERVICE);

        if (nm != null) {
            NotificationChannel nChannel = nm.getNotificationChannel(id);
            if (nChannel == null) {
                nChannel = new NotificationChannel(id, appName, importance);
                nm.createNotificationChannel(nChannel);
            }
        }
    }


    public static void cancelNotification(Context context, int notificaitonId) {
        NotificationManager notificationManager = (NotificationManager) context.getApplicationContext().getSystemService(Context.NOTIFICATION_SERVICE);
        if (notificationManager != null) {
            notificationManager.cancel(notificaitonId);
        }
    }
}
