package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by tarek on 11/5/16.
 */

public class DrawingUtility {

  public static void drawLine(Canvas canvas, PointF startP, PointF endP, Paint paint) {
    canvas.drawLine(startP.x, startP.y, endP.x, endP.y, paint);
  }

  public static float getRotationDegrees(float x1, float y1, float x2, float y2) {
    double x = x1 - x2;
    double y = y1 - y2;
    double radians = Math.atan2(y, x);
    return (float) Math.toDegrees(radians);
  }

  public static void pointOnCircle(float radius, float angleInDegrees, PointF origin, PointF dst) {
    // Convert from degrees to radians via multiplication by PI/180
    dst.x = (float) (radius * Math.cos(angleInDegrees * Math.PI / 180F)) + origin.x;
    dst.y = (float) (radius * Math.sin(angleInDegrees * Math.PI / 180F)) + origin.y;
  }

  public static PointF pointOnCircle(float radius, float angleInDegrees, PointF origin) {
    PointF point = new PointF();
    pointOnCircle(radius, angleInDegrees, origin, point);
    return point;
  }

  public static PointF rotatePoint(float cx, float cy, float angle, PointF p) {
    double s = Math.sin(angle * Math.PI / 180F);
    double c = Math.cos(angle * Math.PI / 180F);

    // translate point back to origin:
    p.x -= cx;
    p.y -= cy;

    // rotate point
    double newX = p.x * c - p.y * s;
    double newY = p.x * s + p.y * c;

    // translate point back:
    p.x = (float) newX + cx;
    p.y = (float) newY + cy;
    return p;
  }

  //Compute the dot product AB . AC
  public static double dotProduct(double[] pointA, double[] pointB, double[] pointC) {
    double[] AB = new double[2];
    double[] BC = new double[2];
    AB[0] = pointB[0] - pointA[0];
    AB[1] = pointB[1] - pointA[1];
    BC[0] = pointC[0] - pointB[0];
    BC[1] = pointC[1] - pointB[1];
    double dot = AB[0] * BC[0] + AB[1] * BC[1];

    return dot;
  }

  //Compute the cross product AB x AC
  public static double crossProduct(double[] pointA, double[] pointB, double[] pointC) {
    double[] AB = new double[2];
    double[] AC = new double[2];
    AB[0] = pointB[0] - pointA[0];
    AB[1] = pointB[1] - pointA[1];
    AC[0] = pointC[0] - pointA[0];
    AC[1] = pointC[1] - pointA[1];
    double cross = AB[0] * AC[1] - AB[1] * AC[0];

    return cross;
  }

  //Compute the distance from A to B
  public static float getDistance(PointF pointA, PointF pointB) {
    float d1 = pointA.x - pointB.x;
    float d2 = pointA.y - pointB.y;

    return (float) Math.sqrt(d1 * d1 + d2 * d2);
  }

  //Compute the distance from A to B
  public static float getDistance(float[] pointA, float[] pointB) {
    double d1 = pointA[0] - pointB[0];
    double d2 = pointA[1] - pointB[1];

    return (float) Math.sqrt(d1 * d1 + d2 * d2);
  }

  //Compute the distance from A to B
  public static double getDistance(double[] pointA, double[] pointB) {
    double d1 = pointA[0] - pointB[0];
    double d2 = pointA[1] - pointB[1];

    return Math.sqrt(d1 * d1 + d2 * d2);
  }

  //Compute the distance from AB to C
  public static double lineToPointDistance2D(double[] pointA, double[] pointB, double[] pointC) {
    double crossProduct = crossProduct(pointA, pointB, pointC);
    double Distance = getDistance(pointA, pointB);
    double dist = crossProduct / Distance;

    return Math.abs(dist);
  }

  public static double lineToPointDistance2D(PointF pointA, PointF pointB, PointF pointC) {

    double[] a = { pointA.x, pointA.y };
    double[] b = { pointB.x, pointB.y };
    double[] c = { pointC.x, pointC.y };

    return lineToPointDistance2D(a, b, c);
  }

  public static PointF getMidpoint(PointF pointA, PointF pointB) {
    PointF pointC = new PointF();
    pointC.x = (pointA.x + pointB.x) / 2;
    pointC.y = (pointA.y + pointB.y) / 2;

    return pointC;
  }

  public static float degreeToRadian(float angleInDegrees) {
    return (float) (angleInDegrees * (Math.PI / 180F));
  }

  public static float radianToDegree(float radian) {
    return (float) (radian * 180 / Math.PI);
  }

  @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
  public static List<PointF> getPoints(Path path) {
    List<PointF> points = new ArrayList<>();
    PathMeasure pm = new PathMeasure(path, false);
    float length = pm.getLength();
    float[] aCoordinates = new float[2];
    for(int i = 0 ; i < length; i++){
      pm.getPosTan(i, aCoordinates, null);
        points.add(new PointF(aCoordinates[0],
                aCoordinates[1]));
    }
    return points;
  }
}