package com.instabug.library.sessionreplay.model

import androidx.annotation.StringDef
import com.instabug.library.sessionreplay.di.SessionReplayServiceLocator
import com.instabug.library.sessionreplay.model.SRLogType.Companion.IBG_LOG
import com.instabug.library.sessionreplay.model.SRLogType.Companion.NETWORK_LOG
import com.instabug.library.sessionreplay.model.SRLogType.Companion.SCREENSHOT
import com.instabug.library.sessionreplay.model.SRLogType.Companion.USER_STEP
import org.json.JSONObject
import kotlin.annotation.AnnotationRetention.SOURCE

/**
 * Base contract for log models that are meant to be stored and sent with session-replay logs.
 */
interface SRLog {
    /**
     * Returns the creation time stamp
     */
    val timestamp: Long

    /**
     * Returns an integer representing type of log
     */
    @SRLogType
    val logType: String

    /**
     * Returns the JSON representation of the log.
     */
    val srJsonRep: JSONObject?


}

/**
 * to be used to ignore sr logs limitations
 * */

/***
 * get the max value based on SrLogType
 * */

val SRLog.maxSize: Int get() = SessionReplayServiceLocator.limitationsProvider[logType]

@Retention(SOURCE)
@StringDef(value = [USER_STEP, IBG_LOG, NETWORK_LOG, SCREENSHOT])
annotation class SRLogType {
    companion object {
        const val USER_STEP = "USER_STEP"
        const val IBG_LOG = "IBG_LOG"
        const val NETWORK_LOG = "NETWORK_LOG"
        const val SCREENSHOT = "SCREENSHOT"
    }
}