package com.instabug.library.sessionreplay.bitmap

import android.graphics.Bitmap

interface BitmapScaler {
    fun scale(bitmap: Bitmap): Bitmap
}

class SRBitmapScaler(
    private val minimumPixelsSize: Int = 400//TBD
) : BitmapScaler {
    override fun scale(bitmap: Bitmap): Bitmap {
        val newSize = calculateNewSize(bitmap.width, bitmap.height)
        return Bitmap.createScaledBitmap(bitmap, newSize.first, newSize.second, true)
    }

    private fun calculateNewSize(
        width: Int,
        height: Int
    ): Pair<Int, Int> {

        var newWidth = width * 0.25
        var newHeight = height * 0.25

        if (newWidth < minimumPixelsSize || newHeight < minimumPixelsSize) {
            val newFactor = minimumPixelsSize / width.coerceAtMost(height).toDouble()
            newWidth = width * newFactor
            newHeight = height * newFactor
        }
        return newWidth.toInt() to newHeight.toInt()
    }
}