package com.instabug.library.sessionV3.configurations

import com.instabug.library.Constants.LOG_TAG
import com.instabug.library.IBGFeature.Companion.RATING_DIALOG_DETECTION
import com.instabug.library.internal.sharedpreferences.corePref
import com.instabug.library.model.v3Session.Defaults.DEFAULT_ALLOWED_INTERVAL_BEFORE_REDIRECTION
import com.instabug.library.model.v3Session.Defaults.DEFAULT_CUSTOM_STORE_RATE_API
import com.instabug.library.model.v3Session.PreferencesKeys.ALLOWED_INTERVAL_BEFORE_REDIRECTION
import com.instabug.library.model.v3Session.PreferencesKeys.CUSTOM_STORE_RATE_API_ENABLED
import com.instabug.library.model.v3Session.RatingDialogDetection.CUSTOM_STORE_RATE_ALLOWED_INTERVAL_BEFORE_REDIRECTION_KEY
import com.instabug.library.model.v3Session.RatingDialogDetection.CUSTOM_STORE_RATE_API_ENABLED_KEY
import com.instabug.library.util.InstabugSDKLogger
import org.json.JSONObject

interface RatingDialogDetectionConfigurations {
    var isEnabled: Boolean
    val isCustomStoreRateApiEnabled: Boolean
    val allowedIntervalBeforeRedirection: Long
    fun handle(responseJson: JSONObject)
}

object RatingDialogDetectionConfigurationsImpl : RatingDialogDetectionConfigurations {

    override var isEnabled: Boolean
            by corePref(RATING_DIALOG_DETECTION, false)
    override var isCustomStoreRateApiEnabled: Boolean
            by corePref(CUSTOM_STORE_RATE_API_ENABLED, DEFAULT_CUSTOM_STORE_RATE_API)
        private set
    override var allowedIntervalBeforeRedirection: Long
            by corePref(
                ALLOWED_INTERVAL_BEFORE_REDIRECTION,
                DEFAULT_ALLOWED_INTERVAL_BEFORE_REDIRECTION
            )

    override fun handle(responseJson: JSONObject) {
        responseJson.runCatching {
            isEnabled = optBoolean(RATING_DIALOG_DETECTION)
            isCustomStoreRateApiEnabled = optBoolean(CUSTOM_STORE_RATE_API_ENABLED_KEY)
            allowedIntervalBeforeRedirection = optLong(
                CUSTOM_STORE_RATE_ALLOWED_INTERVAL_BEFORE_REDIRECTION_KEY,
                DEFAULT_ALLOWED_INTERVAL_BEFORE_REDIRECTION
            )
        }.onFailure {
            InstabugSDKLogger.e(
                LOG_TAG,
                "Error occurred while parsing $RATING_DIALOG_DETECTION: ${it.message}"
            )
        }
    }
}

