package com.instabug.library.screenshot.analytics

sealed class AnalyticsEvent {
    /**
     * The event accrue when new screenshot Errors happened.
     * @see ScreenshotsErrorCodes
     */
    class ErrorEvent(
        @ScreenshotsErrorCodes val errorCode: String,
        val cause: Throwable? = null,
        val reportNonFatal: Boolean = true
    ) : AnalyticsEvent()

    object ClearScreenShotAnalyticsData : AnalyticsEvent()

    sealed class ScreenshotEvent : AnalyticsEvent() {
        /**
         * The event accrue before new screen shot captured successfully.
         * @see ProductAnalyticsCollector
         */
        object OnConfigurationChanged : ScreenshotEvent()

        /**
         * The event accrue when new screen shot captured successfully.
         *  @see CommonAnalyticsCollector
         */
        object NewScreenshotCaptured : ScreenshotEvent()

        /**
         * The event accrue when screen shots reach limit .
         * @see CommonAnalyticsCollector
         */
        object ScreenshotsTrimmed : ScreenshotEvent()


    }
}
