package com.instabug.library.percentagefeatures;

import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.MathUtils;

public class IBGPercentageFlagsResolver {

    public static void resolve(String featureName, double value) {
        if (featureName != null && SettingsManager.getInstance() != null) {
            PercentageFeature feature = SettingsManager.getInstance().getPercentageFeature(featureName);

            if (feature.getBeValue() == 0 || feature.getSdkValue() == 0) {
                feature.setSdkValue(MathUtils.generateRandomNumber(1.0));
            }
            feature.setBeValue(value);

            boolean featureEnabled = value != 0.0 && feature.getSdkValue() <= value;
            if(SettingsManager.getInstance() != null) {
                SettingsManager.getInstance().savePercentageFeature(featureName, feature);
                SettingsManager.getInstance().setFeatureEnabled(featureName, featureEnabled);
            }
        }
    }
}
