package com.instabug.library.networkv2.service.userattributes;

import android.content.Context;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.library.Constants;
import com.instabug.library.IBGFeature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.utils.PreferencesUtils;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.UserManager;
import com.instabug.library.util.InstabugSDKLogger;

public class AttributesSyncManager {

    @Nullable
    private AttributesRepository repository;

    AttributesSyncManager(@Nullable AttributesRepository repository) {
        this.repository = repository;
    }

    public static AttributesSyncManager create(Context context) {
        NetworkManager networkManager = new NetworkManager();
        PreferencesUtils preferencesUtils = new PreferencesUtils(context, SettingsManager.INSTABUG_SHARED_PREF_NAME);
        AttributesRemoteDataSource remoteDataSource = new AttributesRemoteDataSource(networkManager, preferencesUtils);
        AttributesLocalDataSource localDataSource = new AttributesLocalDataSource();
        AttributesRepository repository = new AttributesRepository(remoteDataSource, localDataSource);
        return new AttributesSyncManager(repository);
    }

    public void sync() {
        if (!currentUserIsIdentified()) {
            InstabugSDKLogger.d(Constants.LOG_TAG, "Couldn't sync attributes current user is not identified");
        } else if (!syncFeatureIsEnabled()) {
            InstabugSDKLogger.d(Constants.LOG_TAG, "Couldn't sync attributes sync feature is not available");
        } else {
            String uuid = UserManager.getUUID();
            String email = UserManager.getIdentifiedUserEmail();
            if(repository != null) {
                repository.sync(uuid, email);
            }
        }
    }

    @VisibleForTesting
    boolean currentUserIsIdentified() {
        return UserManager.isLoggedIn();
    }

    @VisibleForTesting
    boolean syncFeatureIsEnabled() {
        return InstabugCore.isExperimentalFeatureAvailable(IBGFeature.BE_USER_ATTRIBUTES);
    }
}
