package com.instabug.library.networkv2.service.userattributes;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.library.Constants;
import com.instabug.library.model.UserAttribute;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;

import java.util.ArrayList;
import java.util.List;

class AttributesRepository {

    private final AttributesRemoteDataSource remoteDataSource;
    private final AttributesLocalDataSource localDataSource;

    AttributesRepository(AttributesRemoteDataSource remoteDataSource,
                         AttributesLocalDataSource localDataSource) {
        this.remoteDataSource = remoteDataSource;
        this.localDataSource = localDataSource;
    }

    void sync(final String uuid, String email) {
        Request request = remoteDataSource.getRequest(email);

        remoteDataSource.query(request, new Request.Callbacks<List<UserAttribute>, Throwable>() {
            @Override
            public void onSucceeded(List<UserAttribute> attributes) {
                if (attributes != null) {
                    List<UserAttribute> userAttributes = appendDetails(attributes, uuid, false, UserAttribute.Type.BACKEND);
                    localDataSource.deleteAll();
                    localDataSource.saveOrUpdateBatch(userAttributes);
                }
            }

            @Override
            public void onFailed(Throwable error) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Syncing user attributes got error: " + error.getMessage(), error);
            }
        });
    }

    @VisibleForTesting
    List<UserAttribute> appendDetails(List<UserAttribute> originalAttributes,
                                      String uuid, boolean anonymous, int type) {
        List<UserAttribute> modifiedAttributes = new ArrayList<>();
        for (UserAttribute originalAttribute : originalAttributes) {
            modifiedAttributes.add(originalAttribute.builder()
                    .anonymous(anonymous)
                    .uuid(uuid)
                    .type(type)
                    .build());
        }
        return modifiedAttributes;
    }
}
