package com.instabug.library.model.v3Session

import com.instabug.library.Feature
import com.instabug.library.IBGFeature
import com.instabug.library.core.InstabugCore
import com.instabug.library.model.common.Extractable
import com.instabug.library.sessionV3.providers.SessionProductionUsageProvider

data class SessionProductionUsage(
    val storeURL: String,
    val bugs: Boolean,
    val surveys: Boolean,
    val featureRequest: Boolean,
    val apm: Boolean,
    val crashes: Boolean,
) : Extractable {
    companion object Factory {
        fun create(productionUsageProvider: SessionProductionUsageProvider) =
            with(productionUsageProvider) {
                SessionProductionUsage(
                    storeURL = storeURL,
                    bugs = bugsEnabled,
                    surveys = surveysEnabled,
                    apm = apmEnabled,
                    crashes = crashesEnabled,
                    featureRequest = featureRequestEnabled
                )
            }
    }

    override fun extractFields(map: MutableMap<String, Any>): MutableMap<String, Any> =
        map.apply {
            if (InstabugCore.isFeatureAvailable(IBGFeature.PRODUCTION_USAGE_DETECTION)) {
                put(ProductionUsageKeys.STORE_URL_KEY, storeURL)
                put(ProductionUsageKeys.BUGS_PRODUCTION_USAGE_KEY, bugs)
                put(ProductionUsageKeys.FEATURES_REQUESTS_PRODUCTION_USAGE_KEY, featureRequest)
                put(ProductionUsageKeys.SURVEYS_PRODUCTION_USAGE_KEY, surveys)
                put(ProductionUsageKeys.APM_PRODUCTION_USAGE_KEY, apm)
            }
            put(ProductionUsageKeys.CRASHES_PRODUCTION_USAGE_KEY, crashes)
        }
}