package com.instabug.library.internal.storage.operation;

import android.annotation.SuppressLint;
import android.net.Uri;

import com.instabug.library.util.threading.PoolProvider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

import androidx.annotation.Nullable;

public class ReadStateFromFileDiskOperation implements DiskOperation<String, Void> {

    private final Uri uri;

    public ReadStateFromFileDiskOperation(Uri uri) {
        this.uri = uri;
    }

    @Override
    public String execute(Void aVoid) throws IOException, OutOfMemoryError {
        return getTextFromFile();
    }

    @Override
    public void executeAsync(Void aVoid, @Nullable final DiskOperationCallback<String> callback) {
        PoolProvider.postIOTask(new Runnable() {
            @Override
            public void run() {
                if (callback != null) {
                    try {
                        callback.onSuccess(getTextFromFile());
                    } catch (IOException e) {
                        callback.onFailure(e);
                    }
                }
            }
        });
    }

    private String getTextFromFile() throws OutOfMemoryError, IOException {
        if (uri.getPath() == null) { return ""; }
        StringBuilder builder = new StringBuilder();
        File file = new File(uri.getPath());
        FileInputStream in = new FileInputStream(file);
        InputStreamReader inReader = new InputStreamReader(in, Charset.forName("UTF8"));
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(inReader);
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        return builder.toString();
    }
}
