package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMSessionMetaDataEntry
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DEFAULT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.INTEGER_TYPE
import com.instabug.library.internal.storage.cache.db.contract.apm.ApmAppFlowEntry
import com.instabug.library.internal.storage.cache.db.contract.apm.ApmAppFlowTableAttributeEntry

class Migration_49_50: Migration {

    override fun migrate(db: SQLiteDatabase?) {
        db?.apply {
            createAppFlowTables()
            addSessionMetaDataAppFlowFields()
        }
    }

    private fun SQLiteDatabase.createAppFlowTables() {
        execSQL(ApmAppFlowEntry.CREATE_TABLE_QUERY)
        execSQL(ApmAppFlowTableAttributeEntry.CREATE_TABLE_QUERY)
    }

    private fun SQLiteDatabase.addSessionMetaDataAppFlowFields() {
        execSQL(
            "ALTER TABLE ${APMSessionMetaDataEntry.TABLE_NAME} " +
                    "ADD COLUMN ${APMSessionMetaDataEntry.COLUMN_APM_APP_FLOW_COUNT} " +
                    "$INTEGER_TYPE $DEFAULT ${APMSessionMetaDataEntry.COUNT_DEFAULT_VALUE}"
        )
        execSQL(
            "ALTER TABLE ${APMSessionMetaDataEntry.TABLE_NAME} " +
                    "ADD COLUMN ${APMSessionMetaDataEntry.COLUMN_APM_APP_FLOW_DROPPED_COUNT} " +
                    "$INTEGER_TYPE $DEFAULT ${APMSessionMetaDataEntry.COUNT_DEFAULT_VALUE}"
        )
    }
}