package com.instabug.library.featuresflags.configs

import com.instabug.library.internal.servicelocator.Provider
import com.instabug.library.util.extenstions.runOrLogError
import org.json.JSONObject

class CompositeFeatureFlagsConfigurationHandler(
    private val configurationHandlerProviders: List<Provider<out FeatureFlagsConfigsHandler?>>
) : FeatureFlagsConfigsHandler {

    override fun handleConfigs(featuresResponse: JSONObject) {
        configurationHandlerProviders.forEach {
            runOrLogError {
                it.invoked()?.handleConfigs(featuresResponse)
            }
        }
    }
}
