package com.instabug.library.diagnostics.sdkEvents

import com.instabug.library.diagnostics.sdkEvents.configurations.SDKEventConfigs
import com.instabug.library.diagnostics.sdkEvents.di.SDKEventsServiceLocator
import com.instabug.library.diagnostics.sdkEvents.mappers.sdkEventsFromJsonArray
import com.instabug.library.networkv2.request.RequestParameter
import org.json.JSONArray

internal fun onSuccessResolveSDKEvents(
    requestParameters: List<RequestParameter<*>>?,
    sdkEventsManager: SDKEventsManager = SDKEventsServiceLocator.sdkEventsManager
) {
    requestParameters?.find { it.key == SDKEventConfigs.SDK_EVENTS_KEY }
        ?.run { sdkEventsFromJsonArray(value as? JSONArray) }
        ?.let(sdkEventsManager::updateSyncedRecords)
}