package com.instabug.library.coreSDKChecks

import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent
import com.instabug.library.settings.SettingsManager

class CurrentOSVersionChangeHandler(private val settingsManager: SettingsManager?) {
    fun setOsVersion(currentOsVersion: Int) {
        settingsManager?.run {
            if (!isOSVersionSet) osVersion = currentOsVersion
            else if (osVersion != currentOsVersion) onOSVersionChanged(currentOsVersion)
        }
    }

    private fun onOSVersionChanged(currentOsVersion: Int) {
        settingsManager?.osVersion = currentOsVersion
        IBGCoreEventPublisher.post(IBGSdkCoreEvent.OSVersionChanged)
    }
}