package com.instabug.library.core.ui;

import android.annotation.SuppressLint;
import android.view.ViewStub;

import com.instabug.library.R;
import com.instabug.library.settings.SettingsManager;

import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;

/**
 * Created by mzelzoghbi on 4/12/18.
 */
@SuppressLint("UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD")
public abstract class BaseToolbarActivity<P extends BaseContract.Presenter>
        extends BaseFragmentActivity<P> {

    @Nullable
    protected Toolbar toolbar;

    @Override
    protected int getLayout() {
        return R.layout.instabug_toolbar_activity;
    }

    @Override
    protected void initViews() {
        initToolbar();

        ViewStub content = findViewById(R.id.instabug_content);

        content.setLayoutResource(getContentLayout());

        content.inflate();

        initContentViews();

    }

    private void initToolbar() {
        toolbar = findViewById(R.id.instabug_toolbar);
        Toolbar currentToolbar = toolbar;
        if (currentToolbar != null) {
            currentToolbar.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
            setSupportActionBar(currentToolbar);
            if (getSupportActionBar() != null) {
                getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            }
            currentToolbar.setNavigationIcon(R.drawable.ibg_core_ic_close);
        }
    }

    protected abstract void initContentViews();

    protected abstract int getContentLayout();

}
