package com.instabug.library;

import static com.instabug.library.LogLevel.DEBUG;
import static com.instabug.library.LogLevel.ERROR;
import static com.instabug.library.LogLevel.NONE;
import static com.instabug.library.LogLevel.VERBOSE;

import androidx.annotation.IntDef;
import androidx.annotation.Keep;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Keep
@IntDef({NONE, ERROR, DEBUG, VERBOSE})
@Retention(RetentionPolicy.SOURCE)
public @interface LogLevel {

    /**
     * Priority constant to disable all SDK printed logs.
     */
    int NONE = 0;
    /**
     * Priority constant for SDK error logs.
     */
    int ERROR = 1;
    /**
     * Priority constant for SDK debug logs
     */
    int DEBUG = 2;
    /**
     * Priority constant for SDK verbose logs
     */
    int VERBOSE = 3;
}
