package com.instabug.library.sessionreplay.monitoring

import com.instabug.library.sessionreplay.monitoring.SRErrorCodes.ErrorCompressingLogsFile
import com.instabug.library.sessionreplay.monitoring.SRErrorCodes.ErrorCompressingScreenshot
import com.instabug.library.sessionreplay.monitoring.SRErrorCodes.ErrorFinalizingOldSessions
import com.instabug.library.sessionreplay.monitoring.SRErrorCodes.ErrorStoringScreenshot
import com.instabug.library.sessionreplay.monitoring.SRErrorCodes.ErrorWritingInLogsFile
import com.instabug.library.sessionreplay.monitoring.SRErrorCodes.ErrorZippingScreenshots

object SRErrorCodes {
    // region SR State (50x)
    const val SREnabledInTheMiddleOfSession = "501"

    // region IBG Logs State (51x)
    const val IBGLogsUnavailable = "511"
    const val IBGLogsDisabled = "512"

    // endregion
    // region Network Logs State (52x)
    const val NetworkLogsUnavailable = "521"
    const val NetworkLogsDisabled = "522"

    // endregion
    // region User Steps State (53x)
    const val UserStepsUnavailable = "531"
    const val UserStepsDisabled = "532"

    // endregion
    // region Repro States (54x)
    const val ReproStepsDisabled = "541"
    const val ReproScreenshotsUnavailable = "542"
    const val ReproScreenshotsDisabled = "543"

    // endregion
    // region File Ops (55x)
    const val ErrorWritingInLogsFile = "551"
    const val ErrorCompressingScreenshot = "552"
    const val ErrorStoringScreenshot = "553"
    const val ErrorCompressingLogsFile = "554"
    const val ErrorZippingScreenshots = "555"

    // endregion
    // region Basic Ops (57x)
    const val ErrorFinalizingOldSessions = "571"

    // endregion
}

open class SRMonitoredException(
    val code: String,
    message: String,
    cause: Throwable? = null
) : Exception(message, cause)

// region File Ops Exceptions

class ErrorCreatingSRSessionDirectory(directoryName: String) :
    Exception("$directoryName Doesn't exist.")

class ErrorCreatingSRLogsFile(fileName: String) : Exception("$fileName Doesn't exist.")

class ErrorWritingInSRLogsFile(cause: Throwable?) :
    SRMonitoredException(ErrorWritingInLogsFile, "Failed to write SR log.", cause)

class ErrorCompressingSRScreenshot(cause: Throwable?) :
    SRMonitoredException(ErrorCompressingScreenshot, "Failed to compress screenshot", cause)

class ErrorStoringSRScreenshot(cause: Throwable?) :
    SRMonitoredException(ErrorStoringScreenshot, "Failed to store SR screenshot.", cause)

class ErrorCompressingSRLogsFile(cause: Throwable?) :
    SRMonitoredException(ErrorCompressingLogsFile, "Failed to compress logs file", cause)

class ErrorZippingSRScreenshots(cause: Throwable?) :
    SRMonitoredException(ErrorZippingScreenshots, "Failed to zip screenshots", cause)

// endregion

// region Basic Ops Exceptions
class ErrorFinalizingSROldSessions(cause: Throwable?) :
    SRMonitoredException(ErrorFinalizingOldSessions, "Failed to finalized old SR sessions", cause)

// endregion