package com.instabug.library.networkv2.request;

import static com.instabug.library.networkv2.request.Header.ACCEPT_CHARSET;
import static com.instabug.library.networkv2.request.Header.ANDROID_VERSION;
import static com.instabug.library.networkv2.request.Header.APP_TOKEN;
import static com.instabug.library.networkv2.request.Header.APP_VARIANT;
import static com.instabug.library.networkv2.request.Header.APP_VERSION;
import static com.instabug.library.networkv2.request.Header.AUTHORIZATION;
import static com.instabug.library.networkv2.request.Header.CACHE_CONTROL;
import static com.instabug.library.networkv2.request.Header.CONNECTION;
import static com.instabug.library.networkv2.request.Header.CONTENT_ENCODING;
import static com.instabug.library.networkv2.request.Header.CONTENT_TYPE;
import static com.instabug.library.networkv2.request.Header.DEBUG_MODE_HEADER;
import static com.instabug.library.networkv2.request.Header.ID;
import static com.instabug.library.networkv2.request.Header.IF_MATCH;
import static com.instabug.library.networkv2.request.Header.SDK_VERSION;
import static com.instabug.library.networkv2.request.Header.SESSION_REPLAY_COUNT;
import static com.instabug.library.networkv2.request.Header.SYSTEM_PLATFORM_OS;

import androidx.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * String def define the headers can be set in a request
 */
@Retention(RetentionPolicy.SOURCE)
@StringDef({IF_MATCH, CONTENT_TYPE, ACCEPT_CHARSET, CONTENT_ENCODING, CONNECTION, CACHE_CONTROL,
        AUTHORIZATION, APP_VERSION, SDK_VERSION, DEBUG_MODE_HEADER, ID, SYSTEM_PLATFORM_OS, ANDROID_VERSION, APP_TOKEN, SESSION_REPLAY_COUNT,APP_VARIANT})
public @interface Header {
    String IF_MATCH = "If-Match";
    String CONNECTION = "Connection";
    String CONTENT_TYPE = "Content-Type";
    String CACHE_CONTROL = "Cache-Control";
    String ACCEPT_CHARSET = "Accept-Charset";
    String CONTENT_ENCODING = "Content-Encoding";
    String AUTHORIZATION = "Authorization";
    String APP_VERSION = "app-version";
    String SDK_VERSION = "IBG-SDK-VERSION";
    String APP_TOKEN = "IBG-APP-TOKEN";
    String SYSTEM_PLATFORM_OS = "IBG-OS";
    String ANDROID_VERSION = "IBG-OS-VERSION";
    String DEBUG_MODE_HEADER = "IBG-APM-DEBUG-MODE";
    String SESSION_REPLAY_COUNT = "IBG-SR-COUNT";
    String ID = "id";
    String APP_VARIANT = "IBG-APP-VARIANT";
}
