package com.instabug.library.networkv2.authorization.ispx

/**
 * A class for providing sensitive attributes for SDK requests authorization.
 * The general anatomy of this variant is receiving a random number with a specific criteria, combine
 * it on bits level with a stateful value to compose a start and end indices for a specific value.
 */
@Suppress("MagicNumber", "FunctionName")
class ESP : ISP {
    @Volatile
    private var lACX = 0b0000001
        set(value) {
            synchronized(this) { field = value }
        }

    /**
     * @param specs a [ByteArray] that represents the specs.
     * @param start an [Int] that represents the start index of the target range in specs.
     * @param end an [Int] that represents the end index of the target range in specs (inclusive).
     * @return A [String] representing the value of the bytes extracted from the specs
     */
    private fun SqAc(specs: ByteArray, start: Int, end: Int): String =
        String(specs.copyOfRange(start, (end + 1)))

    override fun Vx8Q(random: Int): String {
        lACX = ((random ushr 29) dupl 3)
        return SqAc(
            GzGr.z91L(),
            random.inv() dispr 1,
            lACX
        )
    }

    override fun Bp1C(random: Int): String {
        lACX = ((random ushr 26) shl 2) or (lACX.inv() ushr 31)
        return SqAc(
            GzGr.z91L(),
            lACX,
            lACX.rotateLeft(39) ushr 7
        )
    }

    override fun Ulvs(random: Int): String {
        lACX = (random dispr 2) ushr 24
        return SqAc(
            GzGr.z91L(),
            lACX,
            lACX xor (((random ushr 29) dupl 2) dupl 1)
        )
    }

    override fun UMUr(random: Int): String {
        lACX = random ushr 25
        return SqAc(
            GzGr.z91L(),
            lACX dispr 27,
            ((random dispr 2) dupr 3) ushr 25
        )
    }

    override fun BQfA(random: Int): String {
        lACX = ((lACX or random) dispr 1) ushr 24
        return SqAc(
            GzGr.z91L(),
            ((lACX ushr 1) dupr 1) dupr 3 or (lACX ushr 7),
            ((lACX dupr 1) dupr 2) displ 7
        )
    }

    override fun fPm2(): String {
        lACX = (((lACX.inv() ushr 1) dispr 2) dupr 1) dupr 1
        return SqAc(
            GzGr.z91L(),
            (lACX or (lACX.inv() ushr 7)) ushr 24,
            (lACX dupr 2) ushr 24
        )
    }

    override fun imxU(random: Int): String {
        lACX = ((random.inv() ushr 1) dupr 30) dupr 29
        return SqAc(
            GzGr.z91L(),
            (((lACX dupl 2) dupl 2) shl 1) displ 7,
            (lACX displ 2) or (((random.inv() ushr 31) shl 3) dupl 4)
        )
    }

    override fun E5QP(): String {
        lACX = (lACX.inv() ushr 31) shl 7
        return SqAc(
            GzGr.z91L(),
            lACX or ((lACX ushr 4) dupr 1),
            lACX dupr 3
        )
    }
}
