package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.diagnostics.diagnostics_db.TEXT_TYPE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMFragmentEntry

class Migration_51_52 : Migration {
    override fun migrate(db: SQLiteDatabase?) {
        db?.apply {
            addAppLaunchIdToFragmentSpans()
        }
    }

    private fun SQLiteDatabase.addAppLaunchIdToFragmentSpans() = execSQL(
        "ALTER TABLE ${APMFragmentEntry.TABLE_NAME} " +
                "ADD COLUMN ${APMFragmentEntry.COLUMN_APP_LAUNCH_ID} $TEXT_TYPE DEFAULT NULL"
    )
}
