package com.instabug.library.internal.storage.cache.db.migrations

import android.content.ContentValues
import android.database.sqlite.SQLiteDatabase
import androidx.annotation.VisibleForTesting
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.CrashEntry.*
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.INTEGER_TYPE
import com.instabug.library.internal.storage.cache.db.MigrationUtilities.columnExists

@VisibleForTesting
const val LEVEL_ERROR = 2

@VisibleForTesting
const val UNHANDLED_CRASH_FLAG_VALUE = 0

@VisibleForTesting
const val HANDLED_CRASH_FLAG_VALUE = 1

class Migration_36_37 : Migration {
    override fun migrate(db: SQLiteDatabase) {
        if (db.columnExists(TABLE_NAME, COLUMN_LEVEL)) return
        db.apply {
            execSQL("ALTER TABLE $TABLE_NAME ADD COLUMN $COLUMN_LEVEL$INTEGER_TYPE DEFAULT NULL")
            update(
                TABLE_NAME,
                ContentValues().apply { put(COLUMN_LEVEL, LEVEL_ERROR) },
                "$COLUMN_HANDLED = ?",
                arrayOf(HANDLED_CRASH_FLAG_VALUE.toString())
            )
        }
    }
}