package com.instabug.library.internal.storage.cache.db;

import android.provider.BaseColumns;

/**
 * Created by mNagy on 12/15/16.
 */

public class InstabugDbContract {

    public static final String TEXT_TYPE = " TEXT";
    public static final String INTEGER_TYPE = " INTEGER";
    public static final String BOOLEAN_TYPE = " BOOLEAN";
    public static final String BLOB_TYPE = " BLOB";
    public static final String COMMA_SEP = ",";
    public static final String CONSTRAINT = " CONSTRAINT ";
    public static final String FOREIGN_KEY = " FOREIGN KEY ";
    public static final String DEFAULT = " DEFAULT ";
    public static final String NULL = " NULL ";
    public static final String UNIQUE = " UNIQUE ";
    private static final String NOT_NULL = " NOT NULL";
    public static final String PRIMARY_KEY = " PRIMARY KEY ";
    public static final String AUTO_INCREMENT = " AUTOINCREMENT ";
    public static final String DROP_STATEMENT = "DROP TABLE IF EXISTS ";
    public static final String DELETE_STATEMENT = "DELETE FROM ";
    public static final String CREATE_TABLE_STATEMENT = "CREATE TABLE IF NOT EXISTS ";
    public static final String ON_DELETE_CASCADE = " ON DELETE CASCADE ";
    public static final String REFERENCES = "REFERENCES ";
    public static final String DELETE_FROM = "DELETE FROM ";


    private InstabugDbContract() {
    }

    public static class NetworkLogEntry implements BaseColumns {
        public static final String TABLE_NAME = "network_logs";

        public static final String COLUMN_DATE = "date";
        public static final String COLUMN_URL = "url";
        public static final String COLUMN_REQUEST = "request";
        public static final String COLUMN_RESPONSE = "response";
        public static final String COLUMN_METHOD = "method";
        public static final String COLUMN_RESPONSE_CODE = "status";
        public static final String COLUMN_HEADERS = "headers";
        public static final String COLUMN_RESPONSE_HEADERS = "response_headers";
        public static final String COLUMN_NETWORK_TIME = "response_time";
        public static final String COLUMN_USER_MODIFIED = "user_modified";

        //Network logs
        public static final String SQL_CREATE_NETWORK_LOGS =
                "CREATE TABLE IF NOT EXISTS " + NetworkLogEntry.TABLE_NAME + " (" +
                        NetworkLogEntry._ID + " INTEGER PRIMARY KEY," +
                        NetworkLogEntry.COLUMN_URL + TEXT_TYPE + COMMA_SEP +
                        NetworkLogEntry.COLUMN_REQUEST + TEXT_TYPE + COMMA_SEP +
                        NetworkLogEntry.COLUMN_METHOD + TEXT_TYPE + COMMA_SEP +
                        NetworkLogEntry.COLUMN_RESPONSE + TEXT_TYPE + COMMA_SEP +
                        NetworkLogEntry.COLUMN_RESPONSE_CODE + INTEGER_TYPE + COMMA_SEP +
                        NetworkLogEntry.COLUMN_HEADERS + TEXT_TYPE + COMMA_SEP +
                        NetworkLogEntry.COLUMN_RESPONSE_HEADERS + TEXT_TYPE + COMMA_SEP +
                        NetworkLogEntry.COLUMN_DATE + TEXT_TYPE + COMMA_SEP +
                        NetworkLogEntry.COLUMN_NETWORK_TIME + INTEGER_TYPE + COMMA_SEP +
                        NetworkLogEntry.COLUMN_USER_MODIFIED + BOOLEAN_TYPE + " )";

        public static final String SQL_DELETE_ENTRIES =
                "DROP TABLE IF EXISTS " + NetworkLogEntry.TABLE_NAME;

        public static final String DELETE_ALL_EXCEPT_THE_LATEST_100_ENTRY =
                "DELETE FROM " + TABLE_NAME + " WHERE " + COLUMN_DATE + " IN (SELECT " +
                        COLUMN_DATE + " FROM " + TABLE_NAME + " ORDER BY " + COLUMN_DATE +
                        " DESC LIMIT -1 OFFSET  %d)";

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class InstabugLogEntry implements BaseColumns {
        public static final String TABLE_NAME = "instabug_logs";

        // DROP instabug_logs table
        public static final String DROP_QUERY_INSTABUG_LOG =
                "DROP TABLE IF EXISTS " + InstabugLogEntry.TABLE_NAME;

    }

    public static class UserEventEntry implements BaseColumns {
        public static final String TABLE_NAME = "user_events_logs";

        public static final String COLUMN_EVENT_IDENTIFIER = "event_identifier";
        public static final String COLUMN_EVENT_LOGGING_COUNT = "event_logging_count";
        public static final String COLUMN_UUID = "uuid";
        public static final String COLUMN_IS_ANONYMOUS = "is_anonymous";

        // CREATE user_events_logs table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( " +
                        COLUMN_UUID + TEXT_TYPE + COMMA_SEP +
                        COLUMN_IS_ANONYMOUS + BOOLEAN_TYPE + COMMA_SEP +
                        COLUMN_EVENT_IDENTIFIER + " TEXT,"
                        + COLUMN_EVENT_LOGGING_COUNT + " INTEGER, "
                        + "CONSTRAINT " + COLUMN_UUID + " "
                        + "    FOREIGN KEY (" + COLUMN_UUID + ") "
                        + "    REFERENCES " + UserEntity.TABLE_NAME + " (" + COLUMN_UUID + ") "
                        + "    ON DELETE CASCADE, "
                        + "PRIMARY KEY (" + COLUMN_UUID + COMMA_SEP + COLUMN_EVENT_IDENTIFIER + "))";
        // DROP user_events_logs table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class SDKEventEntry implements BaseColumns {
        public static final String TABLE_NAME = "sdk_event";
        // DROP sdk_event table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
    }

    public static class SDKApiEntry implements BaseColumns {
        public static final String TABLE_NAME = "sdk_api";
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
    }

    public static class AttachmentEntry implements BaseColumns {
        public static final String TABLE_NAME = "attachments";

        public static final String COLUMN_NAME = "name";
        public static final String COLUMN_LOCALE_PATH = "local_path";
        public static final String COLUMN_URL = "url";
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_ATTACHMENT_STATE = "attachment_state";
        public static final String COLUMN_VIDEO_ENCODED = "video_encoded";
        public static final String COLUMN_DURATION = "duration";
        public static final String COLUMN_REPORT_ID = "report_id";
        public static final String COLUMN_ENCRYPTED = "encrypted";

        // CREATE attachments table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME
                        + " ( "
                        + _ID + " INTEGER PRIMARY KEY, "
                        + COLUMN_NAME + " TEXT UNIQUE, "
                        + COLUMN_LOCALE_PATH + " TEXT, "
                        + COLUMN_URL + " TEXT, "
                        + COLUMN_TYPE + " TEXT, "
                        + COLUMN_ATTACHMENT_STATE + " TEXT, "
                        + COLUMN_VIDEO_ENCODED + " INTEGER, "
                        + COLUMN_DURATION + " TEXT, "
                        + COLUMN_ENCRYPTED + " INTEGER, "
                        + COLUMN_REPORT_ID + " TEXT )";

        // DROP attachments table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class CrashEntry implements BaseColumns {
        public static final String TABLE_NAME = "crashes_table";

        public static final String COLUMN_ID = "crash_id";
        public static final String COLUMN_TEMPORARY_SERVER_TOKEN = "temporary_server_token";
        public static final String COLUMN_CRASH_MESSAGE = "crash_message";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_CRASH_STATE = "crash_state";
        public static final String COLUMN_HANDLED = "handled";
        public static final String COLUMN_RETRY_COUNT = "retry_count";
        public static final String COLUMN_THREADS_DETAILS = "threads_details";
        public static final String COLUMN_FINGERPRINT = "fingerprint";
        public static final String COLUMN_LEVEL = "level";
        public static final String COLUMN_UUID = "uuid";

        // CREATE Crashes table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( " + COLUMN_ID + " TEXT, " + COLUMN_TEMPORARY_SERVER_TOKEN + " TEXT, "
                        + COLUMN_CRASH_MESSAGE + " TEXT, " + COLUMN_CRASH_STATE + " TEXT, "
                        + COLUMN_STATE + " TEXT, " + COLUMN_HANDLED + " INTEGER, "
                        + COLUMN_RETRY_COUNT + " INTEGER" + COMMA_SEP
                        + COLUMN_THREADS_DETAILS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_FINGERPRINT + TEXT_TYPE + " DEFAULT NULL" + COMMA_SEP
                        + COLUMN_LEVEL + INTEGER_TYPE + " DEFAULT NULL" + COMMA_SEP
                        + COLUMN_UUID + TEXT_TYPE + " DEFAULT NULL" + ")";

        // DROP Crashes table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class NDKCrashEntry implements BaseColumns {
        public static final String TABLE_NAME = "ndk_crashes_table";

        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String COLUMN_CRASH_STACK_TRACE = "crash_stack_trace";
        public static final String COLUMN_STATE_FILE = "state_file";
        public static final String COLUMN_TEMP_SERVER_TOKEN = "temp_server_token";
        public static final String COLUMN_SYNC_STATE = "sync_state";
        public static final String COLUMN_UUID = "uuid";

        // CREATE NDK Crashes table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( " + COLUMN_SESSION_ID + TEXT_TYPE + " PRIMARY KEY" + COMMA_SEP
                        + COLUMN_CRASH_STACK_TRACE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_TEMP_SERVER_TOKEN + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SYNC_STATE + INTEGER_TYPE + " default 0" + COMMA_SEP
                        + COLUMN_STATE_FILE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_UUID + TEXT_TYPE + " DEFAULT NULL" + ")";

        // DROP NDK Crashes table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class AnrEntry implements BaseColumns {
        public static final String TABLE_NAME = "anrs_table";

        public static final String COLUMN_ID = "anr_id";
        public static final String COLUMN_ANR_MAIN_THREAD_DATA = "anr_main_thread_data";
        public static final String COLUMN_ANR_REST_OF_THREADS_DATA = "anr_rest_of_threads_data";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_ANR_UPLOAD_STATE = "anr_upload_state";
        public static final String COLUMN_ANR_TEMPORARY_SERVER_TOKEN = "temporary_server_token";
        public static final String COLUMN_ANR_LONG_MESSAGE = "long_message";
        public static final String COLUMN_ANR_VERSION = "anr_version";
        public static final String COLUMN_EARLY_ANR = "early_anr";
        public static final String COLUMN_UUID = "uuid";


        // CREATE ANRs table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( " + COLUMN_ID + " TEXT, " + COLUMN_ANR_MAIN_THREAD_DATA + " TEXT, "
                        + COLUMN_ANR_REST_OF_THREADS_DATA + " TEXT, "
                        + COLUMN_ANR_UPLOAD_STATE + " INTEGER, "
                        + COLUMN_ANR_TEMPORARY_SERVER_TOKEN + " TEXT, "
                        + COLUMN_STATE + " TEXT, " + COLUMN_ANR_LONG_MESSAGE + " TEXT DEFAULT \"\", "
                        + COLUMN_ANR_VERSION + TEXT_TYPE + DEFAULT + "\"v1\" " + COMMA_SEP
                        + COLUMN_EARLY_ANR + BOOLEAN_TYPE + DEFAULT + "0" + COMMA_SEP
                        + COLUMN_UUID + " TEXT DEFAULT NULL)";

        // DROP ANRs table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class ExperimentsEntry implements BaseColumns {
        public static final String TABLE_NAME = "experiments_table";

        public static final String COLUMN_ID = "experiment_id";
        public static final String COLUMN_EXPERIMENT = "experiment";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( " + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_EXPERIMENT + " TEXT)";

        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class SessionEntry implements BaseColumns {
        public static final String TABLE_NAME = "session_table";
        public static final String COLUMN_ID = "session_id";
        public static final String COLUMN_STARTED_AT = "started_at";
        public static final String COLUMN_DURATION = "duration";
        public static final String COLUMN_USER_EVENTS = "user_attributes";
        public static final String COLUMN_USER_ATTRIBUTES = "user_events";
        public static final String COLUMN_USER_EVENTS_KEYS = "user_attributes_keys";
        public static final String COLUMN_USER_ATTRIBUTES_KEYS = "user_events_keys";
        public static final String COLUMN_USER_EMAIL = "user_email";
        public static final String COLUMN_USER_NAME = "user_name";
        public static final String COLUMN_UUID = "uuid";
        public static final String COLUMN_APP_TOKEN = "app_token";
        public static final String COLUMN_OS = "os";
        public static final String COLUMN_DEVICE = "device";
        public static final String COLUMN_SDK_VERSION = "sdk_version";
        public static final String COLUMN_APP_VERSION = "app_version";
        public static final String COLUMN_CRASH_REPORTING_ENABLED = "crash_reporting_enabled";
        public static final String COLUMN_SYNC_STATUS = "sync_status";
        public static final String COLUMN_USERS_PAGE_ENABLED = "users_page_enabled";
        public static final String COLUMN_PRODUCTION_USAGE = "production_usage";
        public static final String COLUMN_STITCHED_SESSION_LEAD = "stitched_session_lead";
        public static final String COLUMN_V2_SESSION_SENT = "v2_session_sent";

        // CREATE session table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( " + COLUMN_ID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_STARTED_AT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_USER_ATTRIBUTES + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_EVENTS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_ATTRIBUTES_KEYS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_EVENTS_KEYS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_EMAIL + TEXT_TYPE + COMMA_SEP
                        + COLUMN_UUID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_OS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_APP_TOKEN + TEXT_TYPE + COMMA_SEP
                        + COLUMN_DEVICE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SDK_VERSION + TEXT_TYPE + COMMA_SEP
                        + COLUMN_APP_VERSION + TEXT_TYPE + COMMA_SEP
                        + COLUMN_CRASH_REPORTING_ENABLED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_USERS_PAGE_ENABLED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SYNC_STATUS + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_PRODUCTION_USAGE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_STITCHED_SESSION_LEAD + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_V2_SESSION_SENT + BOOLEAN_TYPE
                        + " )";

        // DROP session table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class FeatureRequestEntry implements BaseColumns {
        public static final String TABLE_NAME = "feature_requests_table";

        public static final String COLUMN_ID = "_id";
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_DESCRIPTION = "description";
        public static final String COLUMN_STATUS = "status";
        public static final String COLUMN_LIKES_COUNT = "likes_count";
        public static final String COLUMN_COMMENTS_COUNT = "comments_count";
        public static final String COLUMN_IS_LIKED = "liked";
        public static final String COLUMN_DATE = "date";
        public static final String COLUMN_COLOR_CODE = "color_code";
        public static final String COLUMN_CREATOR_NAME = "creator_name";
        // internal use only not available in the object returned from backend
        public static final String COLUMN_VOTE_UPDATED = "ib_user_vote_status";

        // CREATE feature_requests
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY" + COMMA_SEP
                        + COLUMN_TITLE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_DESCRIPTION + TEXT_TYPE + COMMA_SEP
                        + COLUMN_STATUS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_LIKES_COUNT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_COMMENTS_COUNT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_IS_LIKED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DATE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_COLOR_CODE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_CREATOR_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_VOTE_UPDATED + TEXT_TYPE
                        + " )";
        // DROP feature_requests table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class BugEntry implements BaseColumns {
        public static final String TABLE_NAME = "bugs_table";

        public static final String COLUMN_ID = "id";
        public static final String COLUMN_TEMPORARY_SERVER_TOKEN = "temporary_server_token";
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_MESSAGE = "message";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_BUG_STATE = "bug_state";
        public static final String COLUMN_VIEW_HIERARCHY = "view_hierarchy";
        public static final String COLUMN_CATEGORIES_LIST = "categories_list";

        // CREATE bugs table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( " + COLUMN_ID + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_TEMPORARY_SERVER_TOKEN + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_TYPE + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_MESSAGE + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_STATE + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_BUG_STATE + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_VIEW_HIERARCHY + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_CATEGORIES_LIST + TEXT_TYPE
                        + " )";

        // DROP attachments table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class SurveyEntry implements BaseColumns {
        public static final String TABLE_NAME = "surveys_table";

        public static final String COLUMN_ID = "survey_id";
        public static final String COLUMN_TYPE = "survey_type";
        public static final String COLUMN_GOOGLE_PLAY_RATING = "in_app_rating";
        public static final String COLUMN_TITLE = "survey_title";
        public static final String COLUMN_TOKEN = "survey_token";
        public static final String COLUMN_CONDITIONS_OPERATOR = "conditions_operator";
        public static final String COLUMN_ANSWERED = "answered";
        public static final String COLUMN_DISMISSED_AT = "dismissed_at";
        public static final String COLUMN_SHOWN_AT = "shown_at";
        public static final String COLUMN_IS_CANCELLED = "isCancelled";
        public static final String COLUMN_ATTEMPT_COUNT = "attemptCount";
        public static final String COLUMN_EVENT_INDEX = "eventIndex";
        public static final String COLUMN_SHOULD_SHOW_AGAIN = "shouldShowAgain";
        public static final String COLUMN_PAUSED = "paused";
        public static final String COLUMN_SESSIONS_COUNT = "sessionCounter";
        public static final String COLUMN_QUESTIONS = "questions";
        public static final String COLUMN_THANKS_LIST = "thanks_list";
        public static final String COLUMN_TARGET_AUDIENCES = "targetAudiences";
        public static final String COLUMN_CUSTOM_ATTRIBUTES = "customAttributes";
        public static final String COLUMN_USER_EVENTS = "userEvents";
        public static final String COLUMN_SURVEY_STATE = "surveyState";
        public static final String COLUMN_SURVEY_TARGET = "surveyTargeting";
        public static final String COLUMN_SURVEY_TRIGGER_EVENT = "surveyTriggerEvent";
        public static final String COLUMN_SURVEY_IS_LOCALIZED = "isLocalized";
        public static final String COLUMN_SURVEY_LOCALES = "supportedLocales";
        public static final String COLUMN_SURVEY_CURRENT_LOCALE = "currentLocale";
        public static final String COLUMN_SURVEY_IS_DISMISSIBLE = "isDismissible";
        public static final String COLUMN_SESSION_ID = "session_id";

        // CREATE attachments table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY" + COMMA_SEP
                        + COLUMN_TYPE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_GOOGLE_PLAY_RATING + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_TITLE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_TOKEN + TEXT_TYPE + COMMA_SEP
                        + COLUMN_CONDITIONS_OPERATOR + TEXT_TYPE + COMMA_SEP
                        + COLUMN_ANSWERED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DISMISSED_AT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SHOWN_AT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_IS_CANCELLED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_ATTEMPT_COUNT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_EVENT_INDEX + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SHOULD_SHOW_AGAIN + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_PAUSED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SESSIONS_COUNT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_QUESTIONS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_THANKS_LIST + TEXT_TYPE + COMMA_SEP
                        + COLUMN_TARGET_AUDIENCES + TEXT_TYPE + COMMA_SEP
                        + COLUMN_CUSTOM_ATTRIBUTES + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_EVENTS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SURVEY_STATE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SURVEY_TARGET + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SURVEY_TRIGGER_EVENT + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SURVEY_IS_LOCALIZED + BOOLEAN_TYPE + COMMA_SEP
                        + COLUMN_SURVEY_CURRENT_LOCALE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SURVEY_LOCALES + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SURVEY_IS_DISMISSIBLE + BOOLEAN_TYPE + COMMA_SEP
                        + COLUMN_SESSION_ID + TEXT_TYPE
                        + ")";

        // DROP surveys table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    /**
     * This table holds both survey and announcement's users' interactions differentiated between
     * them using  UserInteractions.COLUMN_USER_INTERACTION_ON_TYPE
     */
    public static class UserInteractions implements BaseColumns {
        public static final String TABLE_NAME = "user_interaction";

        public static final String COLUMN_SURVEY_ID = "survey_id";
        public static final String COLUMN_UUID_TYPE = "uuid";
        public static final String COLUMN_USER_INTERACTION_ON_TYPE = "action_on_type";
        public static final String COLUMN_ANSWERED = "answered";
        public static final String COLUMN_DISMISSED_AT = "dismissed_at";
        public static final String COLUMN_SHOWN_AT = "shown_at";
        public static final String COLUMN_IS_CANCELLED = "isCancelled";
        public static final String COLUMN_ATTEMPT_COUNT = "attemptCount";
        public static final String COLUMN_EVENT_INDEX = "eventIndex";
        public static final String COLUMN_SHOULD_SHOW_AGAIN = "shouldShowAgain";
        public static final String COLUMN_SESSIONS_COUNT = "sessionCounter";
        public static final String COLUMN_SURVEY_TARGET = "surveyTargeting";
        public static final String COLUMN_ALREADY_SHOWN = "is_already_shown";

        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_SURVEY_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_UUID_TYPE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SURVEY_TARGET + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_INTERACTION_ON_TYPE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_ANSWERED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DISMISSED_AT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SHOWN_AT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_IS_CANCELLED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_ATTEMPT_COUNT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_EVENT_INDEX + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SHOULD_SHOW_AGAIN + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SESSIONS_COUNT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_ALREADY_SHOWN + INTEGER_TYPE + COMMA_SEP
                        + "CONSTRAINT " + COLUMN_UUID_TYPE + " "
                        + "    FOREIGN KEY (" + COLUMN_UUID_TYPE + ") "
                        + "    REFERENCES " + UserEntity.TABLE_NAME + " (" + COLUMN_UUID_TYPE + ") "
                        + "    ON DELETE CASCADE, "
                        + " PRIMARY KEY (" + COLUMN_SURVEY_ID + COMMA_SEP + COLUMN_UUID_TYPE +
                        COMMA_SEP + COLUMN_USER_INTERACTION_ON_TYPE + "))";

        // DROP UserInteractions table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class AnnouncementEntry implements BaseColumns {
        public static final String TABLE_NAME = "announcement_table";

        public static final String COLUMN_ID = "announcement_id";
        public static final String COLUMN_TYPE = "announcement_type";
        public static final String COLUMN_TITLE = "announcement_title";
        public static final String COLUMN_CONDITIONS_OPERATOR = "conditions_operator";
        public static final String COLUMN_ANSWERED = "answered";
        public static final String COLUMN_DISMISSED_AT = "dismissed_at";
        public static final String COLUMN_SHOWN_AT = "shown_at";
        public static final String COLUMN_IS_CANCELLED = "isCancelled";
        public static final String COLUMN_EVENT_INDEX = "eventIndex";
        public static final String COLUMN_SHOULD_SHOW_AGAIN = "shouldShowAgain";
        public static final String COLUMN_PAUSED = "paused";
        public static final String COLUMN_SESSIONS_COUNT = "sessionCounter";

        public static final String COLUMN_ANNOUNCEMENT = "announcement";
        public static final String COLUMN_TARGET = "targetAudiences";
        public static final String COLUMN_IS_SHOWN = "isAlreadyShown";
        public static final String COLUMN_ANNOUNCE_EVENTS = "surveyEvents";
        public static final String COLUMN_ANNOUNCE_STATE = "surveyState";
        public static final String COLUMN_ASSETS_STATUS = "announceAssetsStatus";
        public static final String COLUMN_ANNOUNCE_IS_LOCALIZED = "isLocalized";
        public static final String COLUMN_ANNOUNCE_LOCALES = "supportedLocales";
        public static final String COLUMN_ANNOUNCE_CURRENT_LOCALE = "currentLocale";

        // CREATE Announcement table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY" + COMMA_SEP
                        + COLUMN_TITLE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_TYPE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_CONDITIONS_OPERATOR + TEXT_TYPE + COMMA_SEP
                        + COLUMN_ANSWERED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DISMISSED_AT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SHOWN_AT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_IS_CANCELLED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_EVENT_INDEX + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SHOULD_SHOW_AGAIN + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_PAUSED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SESSIONS_COUNT + INTEGER_TYPE + COMMA_SEP

                        + COLUMN_ANNOUNCEMENT + TEXT_TYPE + COMMA_SEP
                        + COLUMN_IS_SHOWN + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_TARGET + TEXT_TYPE + COMMA_SEP
                        + COLUMN_ANNOUNCE_EVENTS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_ASSETS_STATUS + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_ANNOUNCE_STATE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_ANNOUNCE_IS_LOCALIZED + BOOLEAN_TYPE + COMMA_SEP
                        + COLUMN_ANNOUNCE_LOCALES + TEXT_TYPE + COMMA_SEP
                        + COLUMN_ANNOUNCE_CURRENT_LOCALE + TEXT_TYPE
                        + ")";

        // DROP Announcement table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Alter the table to add new filed COLUMN_SHOWN_AT
        static final String ALTER_TABLE_UPGRADE_16 =
                String.format("ALTER TABLE %s ADD COLUMN %s %s DEFAULT %s",
                        TABLE_NAME,
                        COLUMN_SHOWN_AT, INTEGER_TYPE,
                        "0");
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class AnnouncementAssetsEntry implements BaseColumns {
        public static final String TABLE_NAME = "announcement_assets_table";

        public static final String COLUMN_ID = "asset_id";
        public static final String COLUMN_ANNOUNCE_ID = "announcement_item_id";
        public static final String COLUMN_FILE_PATH = "asset_path";

        // CREATE Announcement table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY" + COMMA_SEP
                        + COLUMN_ANNOUNCE_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_FILE_PATH + TEXT_TYPE
                        + ")";

        // DROP Announcement table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class UserAttributesEntry implements BaseColumns {
        public static final String TABLE_NAME = "user_attributes_table";
        public static final String ROW_ID = "rowid";
        public static final String COLUMN_UUID = "uuid";
        public static final String COLUMN_KEY = "key";
        public static final String COLUMN_VALUE = "value";
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_IS_ANONYMOUS = "is_anonymous";

        // CREATE UserAttributes table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_UUID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_KEY + TEXT_TYPE + COMMA_SEP
                        + COLUMN_VALUE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_TYPE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_IS_ANONYMOUS + BOOLEAN_TYPE + COMMA_SEP
                        + "CONSTRAINT " + COLUMN_UUID + " "
                        + "    FOREIGN KEY (" + COLUMN_UUID + ") "
                        + "    REFERENCES " + UserEntity.TABLE_NAME + " (" + COLUMN_UUID + ") "
                        + "    ON DELETE CASCADE, "
                        + "PRIMARY KEY (" + COLUMN_UUID + COMMA_SEP + COLUMN_KEY
                        + " ))";

        // DROP UserAttributes table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        public static final String ALTER_TABLE_UPGRADE_14 =
                String.format("ALTER TABLE %s ADD COLUMN " +
                                "%s %s DEFAULT %s",
                        TABLE_NAME,
                        COLUMN_TYPE, INTEGER_TYPE, "0");
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
        private static final String SELECT_ROW_IDS = "SELECT " + ROW_ID
                + " FROM " + TABLE_NAME
                + " ORDER BY " + ROW_ID + " DESC"
                + " LIMIT ? OFFSET ?";

        public static final String TRIM_WHERE_CLAUSE = ROW_ID + " IN (" + SELECT_ROW_IDS + ") AND " +
                //Not BackEnd attribute
                COLUMN_TYPE + " != 1";
    }

    public static class UserEntity implements BaseColumns {
        public static final String TABLE_NAME = "user";

        public static final String COLUMN_UUID = "uuid";
        public static final String COLUMN_SESSION_COUNT = "session_count";
        public static final String COLUMN_LAST_SEEN = "last_seen";
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_UUID + TEXT_TYPE + " PRIMARY KEY" + COMMA_SEP
                        + COLUMN_LAST_SEEN + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SESSION_COUNT + INTEGER_TYPE + " )";

        // DROP UserEntity table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // ALTER UserEntity table BD Schema > 12
        public static final String ALTER_TABLE_UPGRADE_12 =
                String.format("ALTER TABLE %s ADD COLUMN " +
                                "%s %s DEFAULT %s",
                        TABLE_NAME,
                        COLUMN_LAST_SEEN, INTEGER_TYPE, "0");
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class ExecutionTracesEntry {
        public static final String TABLE_NAME = "execution_traces";
        public static final String COLUMN_ID = "trace_id";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String COLUMN_NAME = "name";
        public static final String COLUMN_START_TIME = "start_time";
        public static final String COLUMN_DURATION = "duration";
        public static final String COLUMN_STARTED_ON_BACKGROUND = "started_on_background";
        public static final String COLUMN_ENDED_ON_BACKGROUND = "ended_on_background";
        public static final int DURATION_DEFAULT_VALUE = -1;

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY" + COMMA_SEP
                        + COLUMN_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SESSION_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_STARTED_ON_BACKGROUND + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_ENDED_ON_BACKGROUND + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + " default " + DURATION_DEFAULT_VALUE + COMMA_SEP
                        + CONSTRAINT + COLUMN_SESSION_ID + COMMA_SEP
                        + FOREIGN_KEY + "(" + COLUMN_SESSION_ID + ") REFERENCES "
                        + APMSessionEntry.TABLE_NAME + "(" + APMSessionEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class ExecutionTracesAttributesEntry {
        public static final String TABLE_NAME = "execution_traces_attributes";
        public static final String COLUMN_ID = "attribute_id";
        public static final String COLUMN_EXECUTION_TRACE_ID = "trace_id";
        public static final String COLUMN_KEY = "attribute_key";
        public static final String COLUMN_VALUE = "attribute_value";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_EXECUTION_TRACE_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_KEY + TEXT_TYPE + COMMA_SEP
                        + COLUMN_VALUE + TEXT_TYPE + COMMA_SEP
                        + "CONSTRAINT " + COLUMN_EXECUTION_TRACE_ID + " "
                        + "FOREIGN KEY (" + COLUMN_EXECUTION_TRACE_ID + ") REFERENCES "
                        + com.instabug.library.internal.storage.cache.db.InstabugDbContract.ExecutionTracesEntry.TABLE_NAME + "(" + com.instabug.library.internal.storage.cache.db.InstabugDbContract.ExecutionTracesEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";
        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class NetworkTracesAttributesEntry {
        public static final String TABLE_NAME = "apm_network_traces_attributes";
        public static final String COLUMN_ID = "attribute_id";
        public static final String COLUMN_TRACE_ID = "trace_id";
        public static final String COLUMN_KEY = "attribute_key";
        public static final String COLUMN_VALUE = "attribute_value";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_TRACE_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_KEY + TEXT_TYPE + COMMA_SEP
                        + COLUMN_VALUE + TEXT_TYPE + COMMA_SEP
                        + "CONSTRAINT " + COLUMN_TRACE_ID + " "
                        + "FOREIGN KEY (" + COLUMN_TRACE_ID + ") REFERENCES "
                        + APMNetworkLogEntry.TABLE_NAME + "(" + APMNetworkLogEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";
        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class DanglingNetworkTracesAttributesEntry {
        public static final String TABLE_NAME = "dangling_apm_network_traces_attributes";
        public static final String COLUMN_ID = "attribute_id";
        public static final String COLUMN_TRACE_ID = "trace_id";
        public static final String COLUMN_KEY = "attribute_key";
        public static final String COLUMN_VALUE = "attribute_value";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_TRACE_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_KEY + TEXT_TYPE + COMMA_SEP
                        + COLUMN_VALUE + TEXT_TYPE + COMMA_SEP
                        + "CONSTRAINT " + COLUMN_TRACE_ID + " "
                        + "FOREIGN KEY (" + COLUMN_TRACE_ID + ") REFERENCES "
                        + DanglingAPMNetworkLogEntry.TABLE_NAME + "(" + DanglingAPMNetworkLogEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class AppLaunchEntry {
        public static final String TABLE_NAME = "app_launch";
        public static final String COLUMN_ID = "app_launch_id";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String COLUMN_NAME = "name";
        public static final String COLUMN_SCREEN_NAME = "screen_name";
        public static final String COLUMN_START_TIME = "start_time";
        public static final String COLUMN_DURATION = "duration";
        public static final int DURATION_DEFAULT_VALUE = -1;

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_SESSION_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SCREEN_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + " default " + DURATION_DEFAULT_VALUE + COMMA_SEP
                        + CONSTRAINT + COLUMN_SESSION_ID + COMMA_SEP
                        + FOREIGN_KEY + "(" + COLUMN_SESSION_ID + ") REFERENCES "
                        + APMSessionEntry.TABLE_NAME + "(" + APMSessionEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class AppLaunchAttributesEntry {
        public static final String TABLE_NAME = "app_launch_attributes";
        public static final String COLUMN_ID = "attribute_id";
        public static final String COLUMN_APP_LAUNCH_ID = "app_launch_id";
        public static final String COLUMN_KEY = "attribute_key";
        public static final String COLUMN_VALUE = "attribute_value";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_APP_LAUNCH_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_KEY + TEXT_TYPE + COMMA_SEP
                        + COLUMN_VALUE + TEXT_TYPE + COMMA_SEP
                        + "CONSTRAINT " + COLUMN_APP_LAUNCH_ID + " "
                        + "FOREIGN KEY (" + COLUMN_APP_LAUNCH_ID + ") "
                        + "REFERENCES " + AppLaunchEntry.TABLE_NAME + " (" + AppLaunchEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class APMNetworkLogEntry {
        public static final String TABLE_NAME = "apm_network_log";
        public static final String COLUMN_ID = "log_id";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String COLUMN_START_TIME = "start_time";
        public static final String COLUMN_URL = "url";
        public static final String COLUMN_METHOD = "method";
        public static final String COLUMN_REQUEST_HEADERS = "request_headers";
        public static final String COLUMN_RESPONSE_HEADERS = "response_headers";
        public static final String COLUMN_REQUEST_CONTENT_TYPE = "request_content_type";
        public static final String COLUMN_RESPONSE_CONTENT_TYPE = "response_content_type";
        public static final String COLUMN_DURATION = "duration";
        public static final String COLUMN_RESPONSE_CODE = "response_code";
        public static final String COLUMN_REQUEST_BODY_SIZE = "request_body_size";
        public static final String COLUMN_RESPONSE_BODY_SIZE = "response_body_size";
        public static final String COLUMN_ERROR_MESSAGE = "error_message";
        public static final String COLUMN_RADIO = "radio";
        public static final String COLUMN_CARRIER = "carrier";
        public static final String COLUMN_EXECUTED_ON_BACKGROUND = "executed_on_background";
        public static final String COLUMN_GRAPH_QL_QUERY_NAME = "graph_ql_query_name";
        public static final String COLUMN_SERVER_ERROR_MESSAGE = "server_side_error_message";
        public static final String COLUMN_CLIENT_SIDE_ERROR_CODE = "client_side_error_code";
        public static final String COLUMN_GRPC_METHOD_NAME = "grpc_method_name";

        public static final String COLUMN_USER_MODIFIED = "user_modified";

        public static final String COLUMN_NETWORK_LATENCY_SPANS = "network_latency_spans";
        public static final String COLUMN_EXTERNAL_TRACE_ID = "external_trace_id";
        public static final String COLUMN_EXTERNAL_TRACE_START_TIME_MILLIS = "external_trace_start_time_millis";
        public static final String COLUMN_IS_W3C_EXTERNAL_NETWORK_TRACE_ID_CAPTURED = "is_w3c_trace_id_captured";
        public static final String COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_PID = "w3c_trace_id_pid";
        public static final String COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_TIMESTAMP = "w3c_trace_id_timestamp";
        public static final String COLUMN_GENERATED_W3C_EXTERNAL_NETWORK_TRACE_ID = "generated_w3c_trace_id";
        public static final String COLUMN_CAPTURED_W3C_EXTERNAL_NETWORK_TRACE_ID = "captured_w3c_trace_id";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_SESSION_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_EXECUTED_ON_BACKGROUND + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_URL + TEXT_TYPE + COMMA_SEP
                        + COLUMN_METHOD + TEXT_TYPE + COMMA_SEP
                        + COLUMN_REQUEST_HEADERS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_RESPONSE_HEADERS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_REQUEST_CONTENT_TYPE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_RESPONSE_CONTENT_TYPE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_RESPONSE_CODE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_REQUEST_BODY_SIZE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_RESPONSE_BODY_SIZE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_RADIO + TEXT_TYPE + COMMA_SEP
                        + COLUMN_ERROR_MESSAGE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_CARRIER + TEXT_TYPE + COMMA_SEP
                        + COLUMN_GRAPH_QL_QUERY_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SERVER_ERROR_MESSAGE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_CLIENT_SIDE_ERROR_CODE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_GRPC_METHOD_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_MODIFIED + BOOLEAN_TYPE + DEFAULT + "0" + COMMA_SEP
                        + COLUMN_NETWORK_LATENCY_SPANS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_IS_W3C_EXTERNAL_NETWORK_TRACE_ID_CAPTURED + BOOLEAN_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_PID + INTEGER_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_TIMESTAMP + INTEGER_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_GENERATED_W3C_EXTERNAL_NETWORK_TRACE_ID + TEXT_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_CAPTURED_W3C_EXTERNAL_NETWORK_TRACE_ID + TEXT_TYPE + DEFAULT + NULL + COMMA_SEP
                        + CONSTRAINT + COLUMN_SESSION_ID + COMMA_SEP
                        + FOREIGN_KEY + "(" + COLUMN_SESSION_ID + ") REFERENCES "
                        + APMSessionEntry.TABLE_NAME + "(" + APMSessionEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class APMUiTraceEntry {
        public static final String TABLE_NAME = "apm_ui_traces";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String COLUMN_NAME = "trace_name";
        public static final String COLUMN_SCREEN_TITLE = "screen_title";
        public static final String COLUMN_DURATION = "duration";
        public static final String COLUMN_SMALL_DROPS_DURATION = "small_drops_duration";
        public static final String COLUMN_LARGE_DROPS_DURATION = "large_drop_duration";
        public static final String COLUMN_BATTERY_LEVEL = "batter_level";
        public static final String COLUMN_POWER_SAVE_MODE = "power_save_more_enabled";
        public static final String COLUMN_REFRESH_RATE = "display_refresh_rate";
        public static final String COLUMN_START_TIME = "start_time";
        public static final String COLUMN_CONTAINER_NAME = "container_name";
        public static final String COLUMN_MODULE_NAME = "module_name";
        public static final String COLUMN_ORIENTATION = "orientation";
        public static final String COLUMN_USER_DEFINED = "user_defined";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ("
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_SESSION_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SCREEN_TITLE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SMALL_DROPS_DURATION + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_LARGE_DROPS_DURATION + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_BATTERY_LEVEL + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_POWER_SAVE_MODE + BOOLEAN_TYPE + COMMA_SEP
                        + COLUMN_REFRESH_RATE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_CONTAINER_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_MODULE_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_ORIENTATION + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_DEFINED + BOOLEAN_TYPE + COMMA_SEP
                        + COLUMN_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + CONSTRAINT + COLUMN_SESSION_ID + COMMA_SEP
                        + FOREIGN_KEY + "(" + COLUMN_SESSION_ID + ") REFERENCES "
                        + APMSessionEntry.TABLE_NAME + "(" + APMSessionEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class APMUiLoadingMetricEntry {
        public static final String TABLE_NAME = "apm_ui_loading";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_UI_TRACE_ID = "ui_trace_id";
        public static final String COLUMN_DURATION = "duration_micro";
        public static final String COLUMN_START_TIME = "start_timestamp";
        public static final String COLUMN_TYPE = "type";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_UI_TRACE_ID + INTEGER_TYPE + UNIQUE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_TYPE + TEXT_TYPE + COMMA_SEP
                        + FOREIGN_KEY + "(" + COLUMN_UI_TRACE_ID + ") REFERENCES "
                        + APMUiTraceEntry.TABLE_NAME + "(" + APMUiTraceEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;

    }

    public static class APMUiLoadingStageEntry {
        public static final String TABLE_NAME = "apm_ui_loading_stages";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_UI_LOADING_METRIC_ID = "ui_loading_metric_id";
        public static final String COLUMN_STAGE_NAME = "stage";
        public static final String COLUMN_STAGE_DURATION = "duration";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_UI_LOADING_METRIC_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_STAGE_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_STAGE_DURATION + INTEGER_TYPE + COMMA_SEP
                        + FOREIGN_KEY + "(" + COLUMN_UI_LOADING_METRIC_ID + ") REFERENCES "
                        + APMUiLoadingMetricEntry.TABLE_NAME + "(" + APMUiLoadingMetricEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTS " + TABLE_NAME;

        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class APMSessionEntry implements BaseColumns {
        public static final String TABLE_NAME = "apm_session_table";
        public static final String COLUMN_ID = "session_id";
        public static final String COLUMN_CORE_ID = "core_session_id";
        public static final String COLUMN_CORE_VERSION = "core_session_version";
        public static final String COLUMN_OS = "os";
        public static final String COLUMN_UUID = "uuid";
        public static final String COLUMN_APP_VERSION = "app_version";
        public static final String COLUMN_STARTED_AT = "started_at";
        public static final String COLUMN_DURATION = "duration";
        public static final String COLUMN_TERMINATION_CODE = "termination_code";
        public static final String COLUMN_SYNC_STATUS = "sync_status";

        // CREATE session table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_CORE_ID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_CORE_VERSION + TEXT_TYPE + COMMA_SEP
                        + COLUMN_OS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_UUID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_APP_VERSION + TEXT_TYPE + COMMA_SEP
                        + COLUMN_STARTED_AT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_TERMINATION_CODE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SYNC_STATUS + INTEGER_TYPE + " default " + -1
                        + " )";

        // DROP session table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class
    APMSessionMetaDataEntry {
        public static final String TABLE_NAME = "apm_session_meta_data";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String COLUMN_EXECUTION_TRACES_TOTAL_COUNT = "traces_total_count";
        public static final String COLUMN_APP_LAUNCH_TOTAL_COUNT = "app_launch_total_count";
        public static final String COLUMN_NETWORK_LOGS_TOTAL_COUNT = "network_logs_total_count";
        public static final String COLUMN_UI_TRACES_TOTAL_COUNT = "ui_traces_total_count";
        public static final String COLUMN_EXECUTION_TRACES_DROPPED_COUNT = "traces_dropped_count";
        public static final String COLUMN_APP_LAUNCH_DROPPED_COUNT = "app_launch_dropped_count";
        public static final String COLUMN_NETWORK_LOGS_DROPPED_COUNT = "network_logs_dropped_count";
        public static final String COLUMN_UI_TRACES_DROPPED_COUNT = "ui_traces_dropped_count";
        public static final String COLUMN_EXPERIMENTS_COUNT = "experiments_total_count";
        public static final String COLUMN_FRAGMENT_SPANS_COUNT = "fragment_spans_total_count";
        public static final String COLUMN_FRAGMENT_SPANS_DROPPED_COUNT = "fragment_spans_dropped_count";
        public static final String COLUMN_COMPOSE_SPANS_COUNT = "compose_spans_total_count";
        public static final String COLUMN_COMPOSE_SPANS_DROPPED_COUNT = "compose_spans_dropped_count";
        public static final String COLUMN_WEB_VIEW_TRACES_TOTAL_COUNT = "web_view_traces_total_count";
        public static final String COLUMN_WEB_VIEW_TRACES_DROPPED_COUNT = "web_view_traces_dropped_count";

        public static final String COLUMN_APM_APP_FLOW_COUNT = "apm_flow_total_count";
        public static final String COLUMN_APM_APP_FLOW_DROPPED_COUNT = "apm_flow_dropped_count";
        public static final int COUNT_DEFAULT_VALUE = 0;

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_SESSION_ID + INTEGER_TYPE + " NOT NULL UNIQUE" + COMMA_SEP
                        + COLUMN_EXECUTION_TRACES_TOTAL_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_APP_LAUNCH_TOTAL_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_NETWORK_LOGS_TOTAL_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_UI_TRACES_TOTAL_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_EXECUTION_TRACES_DROPPED_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_APP_LAUNCH_DROPPED_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_NETWORK_LOGS_DROPPED_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_UI_TRACES_DROPPED_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_EXPERIMENTS_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_FRAGMENT_SPANS_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_FRAGMENT_SPANS_DROPPED_COUNT + INTEGER_TYPE + " default " + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_COMPOSE_SPANS_COUNT + INTEGER_TYPE + DEFAULT + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_COMPOSE_SPANS_DROPPED_COUNT + INTEGER_TYPE + DEFAULT + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_WEB_VIEW_TRACES_TOTAL_COUNT + INTEGER_TYPE + DEFAULT + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_WEB_VIEW_TRACES_DROPPED_COUNT + INTEGER_TYPE + DEFAULT + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_APM_APP_FLOW_COUNT + INTEGER_TYPE + DEFAULT + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + COLUMN_APM_APP_FLOW_DROPPED_COUNT + INTEGER_TYPE + DEFAULT + COUNT_DEFAULT_VALUE + COMMA_SEP
                        + CONSTRAINT + COLUMN_SESSION_ID + COMMA_SEP
                        + FOREIGN_KEY + "(" + COLUMN_SESSION_ID + ") REFERENCES "
                        + APMSessionEntry.TABLE_NAME + "(" + APMSessionEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class DanglingExecutionTracesEntry {
        public static final String TABLE_NAME = "dangling_execution_traces";
        public static final String COLUMN_ID = "trace_id";
        public static final String COLUMN_NAME = "name";
        public static final String COLUMN_START_TIME = "start_time";
        public static final String COLUMN_DURATION = "duration";
        public static final String COLUMN_STARTED_ON_BACKGROUND = "started_on_background";
        public static final String COLUMN_ENDED_ON_BACKGROUND = "ended_on_background";
        public static final int DURATION_DEFAULT_VALUE = -1;

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY" + COMMA_SEP
                        + COLUMN_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_STARTED_ON_BACKGROUND + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_ENDED_ON_BACKGROUND + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + " default " + DURATION_DEFAULT_VALUE + " )";

        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class DanglingExecutionTracesAttributesEntry {
        public static final String TABLE_NAME = "dangling_execution_traces_attributes";
        public static final String COLUMN_ID = "attribute_id";
        public static final String COLUMN_EXECUTION_TRACE_ID = "trace_id";
        public static final String COLUMN_KEY = "attribute_key";
        public static final String COLUMN_VALUE = "attribute_value";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_EXECUTION_TRACE_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_KEY + TEXT_TYPE + COMMA_SEP
                        + COLUMN_VALUE + TEXT_TYPE + COMMA_SEP
                        + "CONSTRAINT " + COLUMN_EXECUTION_TRACE_ID + " "
                        + "FOREIGN KEY (" + COLUMN_EXECUTION_TRACE_ID + ") REFERENCES "
                        + DanglingExecutionTracesEntry.TABLE_NAME + "(" + DanglingExecutionTracesEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class DanglingAPMNetworkLogEntry {
        public static final String TABLE_NAME = "dangling_apm_network_log";
        public static final String COLUMN_ID = "log_id";
        public static final String COLUMN_START_TIME = "start_time";
        public static final String COLUMN_URL = "url";
        public static final String COLUMN_METHOD = "method";
        public static final String COLUMN_REQUEST_HEADERS = "request_headers";
        public static final String COLUMN_RESPONSE_HEADERS = "response_headers";
        public static final String COLUMN_REQUEST_CONTENT_TYPE = "request_content_type";
        public static final String COLUMN_RESPONSE_CONTENT_TYPE = "response_content_type";
        public static final String COLUMN_DURATION = "duration";
        public static final String COLUMN_RESPONSE_CODE = "response_code";
        public static final String COLUMN_REQUEST_BODY_SIZE = "request_body_size";
        public static final String COLUMN_RESPONSE_BODY_SIZE = "response_body_size";
        public static final String COLUMN_ERROR_MESSAGE = "error_message";
        public static final String COLUMN_RADIO = "radio";
        public static final String COLUMN_CARRIER = "carrier";
        public static final String COLUMN_EXECUTED_ON_BACKGROUND = "executed_on_background";
        public static final String COLUMN_GRAPH_QL_QUERY_NAME = "graph_ql_query_name";
        public static final String COLUMN_SERVER_ERROR_MESSAGE = "server_side_error_message";
        public static final String COLUMN_CLIENT_SIDE_ERROR_CODE = "client_side_error_code";
        public static final String COLUMN_GRPC_METHOD_NAME = "grpc_method_name";

        public static final String COLUMN_USER_MODIFIED = "user_modified";
        public static final String COLUMN_NETWORK_LATENCY_SPANS = "network_latency_spans";
        public static final String COLUMN_EXTERNAL_TRACE_ID = "external_trace_id";
        public static final String COLUMN_EXTERNAL_TRACE_START_TIME_MILLIS = "external_trace_start_time_millis";
        public static final String COLUMN_IS_W3C_EXTERNAL_NETWORK_TRACE_ID_CAPTURED = "is_w3c_trace_id_captured";
        public static final String COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_PID = "w3c_trace_id_pid";
        public static final String COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_TIMESTAMP = "w3c_trace_id_timestamp";
        public static final String COLUMN_GENERATED_W3C_EXTERNAL_NETWORK_TRACE_ID = "generated_w3c_trace_id";
        public static final String COLUMN_CAPTURED_W3C_EXTERNAL_NETWORK_TRACE_ID = "captured_w3c_trace_id";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_EXECUTED_ON_BACKGROUND + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_URL + TEXT_TYPE + COMMA_SEP
                        + COLUMN_METHOD + TEXT_TYPE + COMMA_SEP
                        + COLUMN_REQUEST_HEADERS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_RESPONSE_HEADERS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_REQUEST_CONTENT_TYPE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_RESPONSE_CONTENT_TYPE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_RESPONSE_CODE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_REQUEST_BODY_SIZE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_RESPONSE_BODY_SIZE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_RADIO + TEXT_TYPE + COMMA_SEP
                        + COLUMN_ERROR_MESSAGE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_CARRIER + TEXT_TYPE + COMMA_SEP
                        + COLUMN_GRAPH_QL_QUERY_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SERVER_ERROR_MESSAGE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_CLIENT_SIDE_ERROR_CODE + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_GRPC_METHOD_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_MODIFIED + BOOLEAN_TYPE + DEFAULT + "0" + COMMA_SEP
                        + COLUMN_NETWORK_LATENCY_SPANS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_IS_W3C_EXTERNAL_NETWORK_TRACE_ID_CAPTURED + BOOLEAN_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_PID + INTEGER_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_TIMESTAMP + INTEGER_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_GENERATED_W3C_EXTERNAL_NETWORK_TRACE_ID + TEXT_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_CAPTURED_W3C_EXTERNAL_NETWORK_TRACE_ID + TEXT_TYPE + DEFAULT + NULL
                        + " )";

        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class APMExperimentEntry {
        public static final String TABLE_NAME = "apm_experiment";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_EXPERIMENT_ARRAY = "experiment_array";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String SESSION_ID_FOREIGN_KEY_CONSTRAINT_NAME = "session_id_foreign_key";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_EXPERIMENT_ARRAY + BLOB_TYPE + COMMA_SEP
                        + COLUMN_SESSION_ID + INTEGER_TYPE + UNIQUE + COMMA_SEP
                        + CONSTRAINT + SESSION_ID_FOREIGN_KEY_CONSTRAINT_NAME
                        + FOREIGN_KEY + "(" + COLUMN_SESSION_ID + ") REFERENCES "
                        + APMSessionEntry.TABLE_NAME + "(" + APMSessionEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTS " + TABLE_NAME;

        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class APMFragmentEntry {
        public static final String TABLE_NAME = "apm_fragment_spans";

        public static final String COLUMN_ID = "id";
        public static final String COLUMN_NAME = "fragment_name";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String COLUMN_APP_LAUNCH_ID = "app_launch_id";

        public static final String CREATE_TABLE_QUERY =
                CREATE_TABLE_STATEMENT + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + PRIMARY_KEY + AUTO_INCREMENT + COMMA_SEP
                        + COLUMN_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_APP_LAUNCH_ID + TEXT_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_SESSION_ID + INTEGER_TYPE + COMMA_SEP
                        + CONSTRAINT + COLUMN_SESSION_ID
                        + FOREIGN_KEY + "(" + COLUMN_SESSION_ID + ") REFERENCES "
                        + APMSessionEntry.TABLE_NAME + "(" + APMSessionEntry.COLUMN_ID + ") "
                        + ON_DELETE_CASCADE
                        + " )";

        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTS " + TABLE_NAME;

        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class APMFragmentEventsEntry {
        public static final String TABLE_NAME = "apm_fragment_spans_events";

        public static final String COLUMN_ID = "id";
        public static final String COLUMN_FRAGMENT_ID = "fragment_id";
        public static final String COLUMN_NAME = "event_name";
        public static final String COLUMN_START_TIME = "start_time";
        public static final String COLUMN_DURATION = "duration";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_FRAGMENT_ID + INTEGER_TYPE + COMMA_SEP
                        + CONSTRAINT + COLUMN_FRAGMENT_ID
                        + FOREIGN_KEY + "(" + COLUMN_FRAGMENT_ID + ") REFERENCES "
                        + APMFragmentEntry.TABLE_NAME + "(" + APMFragmentEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTS " + TABLE_NAME;

        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class APMComposeSpansEntry {
        public static final String TABLE_NAME = "apm_compose_spans";

        public static final String COLUMN_ID = "span_id";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String COLUMN_NAME = "composable_name";
        public static final String COLUMN_SPANS = "spans";
        public static final String COLUMN_SHOW_AS_SCREEN = "show_as_screen";
        public static final String COLUMN_DURATION_MICROS = "duration_micros";
        public static final String COLUMN_START_TIMESTAMP_MICROS = "start_timestamp_micros";

        public static final String CREATE_TABLE_QUERY =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SPANS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SESSION_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SHOW_AS_SCREEN + BOOLEAN_TYPE + DEFAULT + " 0 " + COMMA_SEP
                        + COLUMN_DURATION_MICROS + INTEGER_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_START_TIMESTAMP_MICROS + INTEGER_TYPE + DEFAULT + NULL + COMMA_SEP
                        + CONSTRAINT + COLUMN_SESSION_ID
                        + FOREIGN_KEY + "(" + COLUMN_SESSION_ID + ") REFERENCES "
                        + APMSessionEntry.TABLE_NAME + "(" + APMSessionEntry.COLUMN_ID + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTS " + TABLE_NAME;

        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class APMWebViewTraceEntry {

        public static final String TABLE_NAME = "apm_web_view_trace";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_UI_TRACE_ID = "ui_trace_id";
        public static final String COLUMN_TRACE_URL = "url";
        public static final String COLUMN_START_TIME_STAMP_MICRO = "start_timestamp_micro";
        public static final String COLUMN_DURATION_MICRO = "duration_micro";
        public static final String COLUMN_VITALS_JSON = "vitals_json";
        public static final String COLUMN_IS_FULL_SCREEN = "is_full_screen";

        public static final String CREATE_TABLE_QUERY =
                CREATE_TABLE_STATEMENT + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + PRIMARY_KEY + AUTO_INCREMENT + COMMA_SEP
                        + COLUMN_TRACE_URL + TEXT_TYPE + COMMA_SEP
                        + COLUMN_START_TIME_STAMP_MICRO + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DURATION_MICRO + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_VITALS_JSON + TEXT_TYPE + DEFAULT + NULL + COMMA_SEP
                        + COLUMN_IS_FULL_SCREEN + BOOLEAN_TYPE + COMMA_SEP
                        + COLUMN_UI_TRACE_ID + INTEGER_TYPE + COMMA_SEP
                        + CONSTRAINT + COLUMN_UI_TRACE_ID + COMMA_SEP
                        + FOREIGN_KEY + " ( " + COLUMN_UI_TRACE_ID + " ) REFERENCES "
                        + APMUiTraceEntry.TABLE_NAME + " ( " + APMUiTraceEntry.COLUMN_ID + " )"
                        + ON_DELETE_CASCADE
                        + ");";

        public static final String DROP_TABLE_QUERY = DROP_STATEMENT + TABLE_NAME;

        public static final String DELETE_ALL = DELETE_STATEMENT + TABLE_NAME;

        private APMWebViewTraceEntry() {
        }
    }
}
