package com.instabug.library.internal.media;

import android.media.MediaRecorder;

import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

import java.io.IOException;

public class AudioRecorder {

    private final String mFileName;
    @Nullable
    private MediaRecorder mRecorder = null;
    private boolean isRecording = false;

    public AudioRecorder(String fileName) {
        mFileName = fileName;
    }

    public void start() {
        InstabugSDKLogger.d(Constants.LOG_TAG, "start audio recording");
        mRecorder = new MediaRecorder();
        mRecorder.setAudioSource(MediaRecorder.AudioSource.MIC);
        mRecorder.setOutputFormat(MediaRecorder.OutputFormat.MPEG_4);
        mRecorder.setOutputFile(mFileName);
        mRecorder.setAudioEncoder(MediaRecorder.AudioEncoder.AAC);

        try {
            mRecorder.prepare();
            mRecorder.start();
            isRecording = true;
        } catch (IOException e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Recording audio failed", e);
            isRecording = false;
        }
    }

    public void stopRecording() {
        InstabugSDKLogger.d(Constants.LOG_TAG, "stop audio Recording");
        if (mRecorder == null)
            return;

        if (isRecording) {
            try {
                mRecorder.stop();
                mRecorder.reset();
            } catch (RuntimeException e) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Stopping audio recorder failed", e);
            } finally {
                mRecorder.release();
                isRecording = false;
                mRecorder = null;
            }
        }
    }

    public String getFileName() {
        return mFileName;
    }

}
