package com.instabug.library.internal.dataretention.files;

import android.content.Context;

import com.instabug.library.Instabug;
import com.instabug.library.internal.dataretention.core.PolicyCollector;
import com.instabug.library.logging.disklogs.LoggingFileProvider;

import java.util.Collection;
import java.util.Collections;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class FilePolicyCollector implements PolicyCollector<FileDisposalPolicy> {

    @NonNull
    @Override
    public Collection<FileDisposalPolicy> collect() {
        FileDisposalPolicy policy = getLogsDisposalPolicy();
        return policy == null
                ? Collections.<FileDisposalPolicy>emptyList()
                : Collections.singleton(policy);
    }

    @Nullable
    private FileDisposalPolicy getLogsDisposalPolicy() {
        Context context = Instabug.getApplicationContext();
        return context == null ? null : LoggingFileProvider.getDisposalPolicy(context);
    }
}
