package com.instabug.library.diagnostics.network

import com.instabug.library.networkv2.NetworkManager
import com.instabug.library.networkv2.request.Constants

/**
 * Created by Shannan on 06/09/2021.
 */
interface IBGDiagnosticsSyncManager {
    @Suppress("PropertyName")
    val DIAGNOSTICS_URL
        get() = "${Constants.DIAGNOSTICS_BASE_URL}/diagnostics"

    /**
     * Sync list of {@link NonFatal} with the BE
     *
     * @param nonFatals nonFatals list to be synced
     * @param callback  a network callback to notify caller by request status when finished
     */
    fun sync(callback: IBGDiagnosticsResponseCallback?)

    fun setOnDoRequestListener(onDoRequestListener: NetworkManager.OnDoRequestListener?)
}
