package com.instabug.library.util;

import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.internal.storage.cache.Cacheable;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;


public final class ObjectMapper {


    @Nullable
    public static String toJson(Cacheable cacheable) {
        try {
            return cacheable.toJson();
        } catch (JSONException e) {
            if (e.getMessage() != null) {
                InstabugSDKLogger.e(Constants.LOG_TAG, e.getMessage(), e);
            }
        }
        return null;
    }

    @Nullable
    public static <T extends Cacheable> T fromJson(@Nullable String json, Class<T> clazz) {
        if (json != null) {
            try {
                Constructor<T> constructor = clazz.getConstructor();
                T newInstance = constructor.newInstance();
                newInstance.fromJson(json);
                return newInstance;
            } catch (JSONException e) {
                if (e.getMessage() != null) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, "Error while parsing json", e);
                }
            } catch (NoSuchMethodException e) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "The object must have a public default constructor", e);
            } catch (IllegalAccessException e) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "The object must have a public default constructor", e);
            } catch (InstantiationException e) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "The object must have a public default constructor", e);
            } catch (InvocationTargetException e) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "The object must have a public default constructor", e);
            }
        }
        return null;
    }

    public static JSONObject toJson(Map<String, String> map) {
        JSONObject jsonObject = new JSONObject();
        if (map != null) {
            try {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    jsonObject.put(entry.getKey(), entry.getValue());
                }
            } catch (JSONException e) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "JSONException while converting map to json: " + e.getMessage());
            }
        }
        return jsonObject;
    }
}
