package com.instabug.library.util;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * Created by Barakat on 16/12/2018
 */
public class ListUtils {

    @Nullable
    public static <T> T safeGet(@Nullable List<T> list, int index) {
        if (list != null && index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return null;
    }

    @NonNull
    public static <T> List<T> toList(@Nullable Collection<T> collection) {
        if (collection instanceof List) return (List<T>) collection;
        else return collection == null ? Collections.<T>emptyList() : new ArrayList<>(collection);
    }

    @NonNull
    public static <T> List<List<T>> split(List<T> list, @IntRange(from = 1) int groupSize) {
        if (list == null || list.isEmpty()) return Collections.emptyList();
        groupSize = Math.max(1, groupSize);
        return split(list, groupSize, new ArrayList<List<T>>());
    }

    @NonNull
    private static <T> List<List<T>> split(@NonNull List<T> list, @IntRange(from = 1) int groupSize,
                                           @NonNull List<List<T>> groupHolder) {
        if (list.size() > groupSize) {
            List<T> group = list.subList(0, groupSize);
            groupHolder.add(group);
            return split(list.subList(groupSize, list.size()), groupSize, groupHolder);
        } else {
            groupHolder.add(list);
            return groupHolder;
        }
    }

    public static String joinLongListToString(CharSequence delimiter, List<Long> iterable) {
        StringBuilder joined = new StringBuilder();
        for(int index = 0; index < iterable.size(); index++) {
            joined.append(String.valueOf(iterable.get(index)));

            if(index < iterable.size() -1) {
                joined.append(delimiter);
            }
        }

        return joined.toString();
    }
}
