package com.instabug.library.tracking;

import android.view.MotionEvent;
import android.view.View;

import com.instabug.library.Instabug;
import com.instabug.library.Platform;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.invocation.InvocationManagerContract;
import com.instabug.library.settings.SettingsManager;

/**
 * @author mesbah
 */
public class InstabugTouchEventsHandler {


    public static void handleTouchEvent(MotionEvent event) {
        if (!Instabug.isEnabled())
            return;

        InvocationManagerContract contract = CoreServiceLocator.getInvocationManagerContract();
        if (contract != null) {
            contract.handle(event);
        }
        if (event != null) {
            InstabugInternalTrackingDelegate.getInstance().trackTouchEvent(event);
        }
    }

    public static void handleTouchEvent(View fragmentView) {
        fragmentView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                InvocationManagerContract contract = CoreServiceLocator.getInvocationManagerContract();
                if (contract != null) {
                    contract.handle(event);
                }
                InstabugInternalTrackingDelegate.getInstance().trackTouchEvent(event);

                return false;
            }
        });
    }
}
